/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.util.FailableBiFunction;
import io.xpipe.core.util.FailableFunction;
import io.xpipe.core.util.SecretValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import lombok.NonNull;

public interface ShellControl
extends ProcessControl {
    public Semaphore getCommandLock();

    public void onInit(Consumer<ShellControl> var1);

    @Override
    public String prepareTerminalOpen() throws Exception;

    public String prepareIntermediateTerminalOpen(String var1) throws Exception;

    public String getTemporaryDirectory() throws Exception;

    public void checkRunning() throws Exception;

    default public String executeStringSimpleCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            String string = c.readOrThrow();
            return string;
        }
    }

    default public boolean executeBooleanSimpleCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    default public void executeSimpleCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
    }

    default public void executeSimpleCommand(String command, String failMessage) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
        catch (ProcessOutputException out) {
            throw ProcessOutputException.of(failMessage, out);
        }
    }

    default public String executeStringSimpleCommand(ShellDialect type, String command) throws Exception {
        try (ShellControl sub = this.subShell(type).start();){
            String string = sub.executeStringSimpleCommand(command);
            return string;
        }
    }

    public void restart() throws Exception;

    public boolean isLocal();

    public OsType getOsType();

    public ShellControl elevated(FailableFunction<ShellControl, Boolean, Exception> var1);

    public ShellControl elevationPassword(SecretValue var1);

    public ShellControl initWith(List<String> var1);

    public SecretValue getElevationPassword();

    default public ShellControl subShell(@NonNull ShellDialect type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.subShell(p -> type.getNormalOpenCommand(), (shellProcessControl, s) -> s == null ? type.getNormalOpenCommand() : type.executeCommandWithShell((String)s)).elevationPassword(this.getElevationPassword());
    }

    default public ShellControl subShell(@NonNull List<String> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.subShell(shellProcessControl -> shellProcessControl.getShellDialect().flatten(command), null);
    }

    default public ShellControl subShell(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.subShell(processControl -> command, null);
    }

    public ShellControl subShell(FailableFunction<ShellControl, String, Exception> var1, FailableBiFunction<ShellControl, String, String, Exception> var2);

    public void executeLine(String var1) throws Exception;

    public void cd(String var1) throws Exception;

    @Override
    public ShellControl start() throws Exception;

    public CommandControl command(FailableFunction<ShellControl, String, Exception> var1);

    public CommandControl command(FailableFunction<ShellControl, String, Exception> var1, FailableFunction<ShellControl, String, Exception> var2);

    default public CommandControl command(String ... command) {
        String[] c = (String[])Arrays.stream(command).filter(s -> s != null).toArray(String[]::new);
        return this.command((ShellControl shellProcessControl) -> String.join((CharSequence)"\n", c));
    }

    default public CommandControl command(List<String> command) {
        return this.command((ShellControl shellProcessControl) -> shellProcessControl.getShellDialect().flatten(command));
    }

    public void exitAndWait() throws IOException;
}

