/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

public class ProcessOutputException
extends Exception {
    private final int exitCode;
    private final String output;

    public static ProcessOutputException of(String customPrefix, ProcessOutputException ex) {
        String messageSuffix = ex.getOutput() != null && !ex.getOutput().isBlank() ? ": " + ex.getOutput() : "";
        String message = customPrefix + messageSuffix;
        return new ProcessOutputException(message, ex.getExitCode(), ex.getOutput());
    }

    public static ProcessOutputException of(int exitCode, String output) {
        String messageSuffix = output != null && !output.isBlank() ? ": " + output : "";
        String message = exitCode == -2 ? "Process timed out" + messageSuffix : "Process returned with exit code " + exitCode + messageSuffix;
        return new ProcessOutputException(message, exitCode, output);
    }

    private ProcessOutputException(String message, int exitCode, String output) {
        super(message);
        this.exitCode = exitCode;
        this.output = output;
    }

    public boolean isTimeOut() {
        return this.exitCode == -2;
    }

    public boolean isKill() {
        return this.exitCode == -3;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output;
    }
}

