/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.util.FailableBiFunction;
import io.xpipe.core.util.FailableFunction;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import lombok.NonNull;

public abstract class ProcessControlProvider {
    private static List<ProcessControlProvider> INSTANCES;

    public static void init(ModuleLayer layer) {
        INSTANCES = ServiceLoader.load(layer, ProcessControlProvider.class).stream().map(localProcessControlProviderProvider -> (ProcessControlProvider)localProcessControlProviderProvider.get()).toList();
    }

    public static ShellControl createLocal(boolean stoppable) {
        return INSTANCES.stream().map(localProcessControlProvider -> localProcessControlProvider.createLocalProcessControl(stoppable)).filter(Objects::nonNull).findFirst().orElseThrow();
    }

    public static ShellControl createSub(ShellControl parent, @NonNull FailableFunction<ShellControl, String, Exception> commandFunction, FailableBiFunction<ShellControl, String, String, Exception> terminalCommand) {
        if (commandFunction == null) {
            throw new NullPointerException("commandFunction is marked non-null but is null");
        }
        return INSTANCES.stream().map(localProcessControlProvider -> localProcessControlProvider.sub(parent, commandFunction, terminalCommand)).filter(Objects::nonNull).findFirst().orElseThrow();
    }

    public static CommandControl createCommand(ShellControl parent, @NonNull FailableFunction<ShellControl, String, Exception> command, FailableFunction<ShellControl, String, Exception> terminalCommand) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return INSTANCES.stream().map(localProcessControlProvider -> localProcessControlProvider.command(parent, command, terminalCommand)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static ShellControl createSsh(Object sshStore) {
        return INSTANCES.stream().map(localProcessControlProvider -> localProcessControlProvider.createSshControl(sshStore)).filter(Objects::nonNull).findFirst().orElseThrow();
    }

    public abstract ShellControl sub(ShellControl var1, @NonNull FailableFunction<ShellControl, String, Exception> var2, FailableBiFunction<ShellControl, String, String, Exception> var3);

    public abstract CommandControl command(ShellControl var1, @NonNull FailableFunction<ShellControl, String, Exception> var2, FailableFunction<ShellControl, String, Exception> var3);

    public abstract ShellControl createLocalProcessControl(boolean var1);

    public abstract ShellControl createSshControl(Object var1);
}

