/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.PropertiesFormatsParser;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialects;
import java.util.Locale;
import java.util.Map;

public interface OsType {
    public static final Windows WINDOWS = new Windows();
    public static final Linux LINUX = new Linux();
    public static final MacOs MACOS = new MacOs();

    public static OsType getLocal() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MACOS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nux")) {
            return LINUX;
        }
        throw new UnsupportedOperationException("Unknown operating system");
    }

    public String getHomeDirectory(ShellControl var1) throws Exception;

    public String getName();

    public String getTempDirectory(ShellControl var1) throws Exception;

    public String normalizeFileName(String var1);

    public Map<String, String> getProperties(ShellControl var1) throws Exception;

    public String determineOperatingSystemName(ShellControl var1) throws Exception;

    public static class MacOs
    implements OsType {
        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellDialect().getPrintVariableCommand("TMPDIR"));
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"/", file.split("[\\\\/]+"));
        }

        @Override
        public String getName() {
            return "Mac";
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.subShell(ShellDialects.BASH).command("sw_vers").start();){
                String text = c.readOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            Map<String, String> properties = this.getProperties(pc);
            String name = pc.executeStringSimpleCommand("awk '/SOFTWARE LICENSE AGREEMENT FOR macOS/' '/System/Library/CoreServices/Setup Assistant.app/Contents/Resources/en.lproj/OSXSoftwareLicense.rtf' | awk -F 'macOS ' '{print $NF}' | awk '{print substr($0, 0, length($0)-1)}'");
            return properties.get("ProductName") + " " + name + " " + properties.get("ProductVersion");
        }
    }

    public static class Windows
    implements OsType {
        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("USERPROFILE"));
        }

        @Override
        public String getName() {
            return "Windows";
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("TEMP"));
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"\\", file.split("[\\\\/]+"));
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.command("systeminfo").start();){
                String text = c.readOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            Map<String, String> properties = this.getProperties(pc);
            return properties.get("OS Name") + " " + properties.get("OS Version").split(" ")[0];
        }
    }

    public static class Linux
    implements OsType {
        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            return "/tmp/";
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"/", file.split("[\\\\/]+"));
        }

        @Override
        public String getName() {
            return "Linux";
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            return null;
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            String text;
            try (CommandControl c = pc.command("lsb_release -a").start();){
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, ":").getOrDefault("Description", null);
                    return string;
                }
            }
            c = pc.command("cat /etc/*release").start();
            try {
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, "=").getOrDefault("PRETTY_NAME", null);
                    return string;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            String type = "Unknown";
            try (CommandControl c = pc.command("uname -o").start();){
                String text2 = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    type = text2.strip();
                }
            }
            String version = "?";
            try (CommandControl c = pc.command("uname -r").start();){
                String text3 = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    version = text3.strip();
                }
            }
            return type + " " + version;
        }
    }
}

