/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.source.DataSourceConnection;
import io.xpipe.core.store.StreamDataStore;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class StreamWriteConnection
implements DataSourceConnection {
    protected final StreamDataStore store;
    private final StreamCharset charset;
    protected OutputStream outputStream;
    protected OutputStreamWriter writer;

    public StreamWriteConnection(StreamDataStore store, StreamCharset charset) {
        this.store = store;
        this.charset = charset;
    }

    @Override
    public void init() throws Exception {
        if (this.outputStream != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.outputStream = this.store.openOutput();
        if (this.charset != null) {
            if (this.charset.hasByteOrderMark()) {
                this.outputStream.write(this.charset.getByteOrderMark());
            }
            this.writer = new OutputStreamWriter(this.outputStream, this.charset.getCharset());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.outputStream == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.outputStream.close();
    }
}

