/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.process.ProcessControlProvider;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialects;
import io.xpipe.core.store.ConnectionFileSystem;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.ShellStore;
import io.xpipe.core.util.JacksonizedValue;
import java.nio.file.Path;
import java.util.Map;

@JsonTypeName(value="local")
public class LocalStore
extends JacksonizedValue
implements ShellStore {
    private static ShellControl local;
    private static FileSystem localFileSystem;

    public static ShellControl getShell() throws Exception {
        if (local == null) {
            local = ProcessControlProvider.createLocal(false).start();
        }
        return local;
    }

    public static FileSystem getFileSystem() throws Exception {
        if (localFileSystem == null) {
            localFileSystem = new LocalStore().createFileSystem();
        }
        return localFileSystem;
    }

    @Override
    public FileSystem createFileSystem() {
        return new ConnectionFileSystem(ShellStore.createLocal().create(), this){

            @Override
            public FileSystemStore getStore() {
                return LocalStore.this;
            }

            private Path wrap(String file) {
                for (Map.Entry<String, String> e : System.getenv().entrySet()) {
                    file = file.replace(ShellDialects.getPlatformDefault().environmentVariable(e.getKey()), e.getValue());
                }
                return Path.of(file, new String[0]);
            }
        };
    }

    @Override
    public ShellControl createControl() {
        return ProcessControlProvider.createLocal(true);
    }
}

