/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.store.DataStore;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;

@JsonTypeName(value="localDir")
public class LocalDirectoryDataStore
implements DataStore {
    private final Path file;

    @JsonCreator
    public LocalDirectoryDataStore(Path file) {
        this.file = file;
    }

    @Override
    public Optional<String> determineDefaultName() {
        return Optional.of(this.file.getFileName().toString());
    }

    @Override
    public Optional<Instant> determineLastModified() {
        try {
            FileTime l = Files.getLastModifiedTime(this.file, new LinkOption[0]);
            return Optional.of(l.toInstant());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Path getPath() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalDirectoryDataStore)) {
            return false;
        }
        LocalDirectoryDataStore other = (LocalDirectoryDataStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$file = this.file;
        Path other$file = other.file;
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalDirectoryDataStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $file = this.file;
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }
}

