/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.store.DataFlow;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.DataStateProvider;
import io.xpipe.core.util.JacksonizedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;

@JsonTypeName(value="internalStream")
@JsonDeserialize(builder=InternalStreamStoreBuilderImpl.class)
public class InternalStreamStore
extends JacksonizedValue
implements StreamDataStore {
    private final UUID uuid;

    public InternalStreamStore() {
        this.uuid = UUID.randomUUID();
    }

    @Override
    public DataFlow getFlow() {
        return DataFlow.INPUT_OUTPUT;
    }

    @Override
    public Optional<String> determineDefaultName() {
        return Optional.of(this.uuid.toString());
    }

    private Path getFile() {
        return DataStateProvider.get().getInternalStreamStore(this.uuid);
    }

    @Override
    public Optional<Instant> determineLastModified() throws IOException {
        return Optional.of(Files.getLastModifiedTime(this.getFile(), new LinkOption[0]).toInstant());
    }

    @Override
    public InputStream openInput() throws Exception {
        return Files.newInputStream(this.getFile(), new OpenOption[0]);
    }

    @Override
    public OutputStream openOutput() throws Exception {
        return Files.newOutputStream(this.getFile(), new OpenOption[0]);
    }

    protected InternalStreamStore(InternalStreamStoreBuilder<?, ?> b) {
        super(b);
        this.uuid = b.uuid;
    }

    public static InternalStreamStoreBuilder<?, ?> builder() {
        return new InternalStreamStoreBuilderImpl();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static abstract class InternalStreamStoreBuilder<C extends InternalStreamStore, B extends InternalStreamStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private UUID uuid;

        public B uuid(UUID uuid) {
            this.uuid = uuid;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InternalStreamStore.InternalStreamStoreBuilder(super=" + super.toString() + ", uuid=" + String.valueOf(this.uuid) + ")";
        }
    }

    @JsonTypeName(value="internalStream")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InternalStreamStoreBuilderImpl
    extends InternalStreamStoreBuilder<InternalStreamStore, InternalStreamStoreBuilderImpl> {
        private InternalStreamStoreBuilderImpl() {
        }

        @Override
        protected InternalStreamStoreBuilderImpl self() {
            return this;
        }

        @Override
        public InternalStreamStore build() {
            return new InternalStreamStore(this);
        }
    }
}

