/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.JacksonizedValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

@JsonTypeName(value="inMemory")
@JsonDeserialize(builder=InMemoryStoreBuilderImpl.class)
public class InMemoryStore
extends JacksonizedValue
implements StreamDataStore {
    private byte[] value;

    @Override
    public String toString() {
        return this.value != null && this.value.length > 100 ? "<memory>" : (this.value != null ? new String(this.value) : "null");
    }

    @Override
    public boolean isContentExclusivelyAccessible() {
        return true;
    }

    @Override
    public InputStream openInput() throws Exception {
        return this.value != null ? new ByteArrayInputStream(this.value) : InputStream.nullInputStream();
    }

    @Override
    public OutputStream openOutput() throws Exception {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                InMemoryStore.this.value = this.toByteArray();
            }
        };
    }

    protected InMemoryStore(InMemoryStoreBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
    }

    public static InMemoryStoreBuilder<?, ?> builder() {
        return new InMemoryStoreBuilderImpl();
    }

    public byte[] getValue() {
        return this.value;
    }

    public InMemoryStore() {
    }

    public InMemoryStore(byte[] value) {
        this.value = value;
    }

    public static abstract class InMemoryStoreBuilder<C extends InMemoryStore, B extends InMemoryStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private byte[] value;

        public B value(byte[] value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InMemoryStore.InMemoryStoreBuilder(super=" + super.toString() + ", value=" + Arrays.toString(this.value) + ")";
        }
    }

    @JsonTypeName(value="inMemory")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InMemoryStoreBuilderImpl
    extends InMemoryStoreBuilder<InMemoryStore, InMemoryStoreBuilderImpl> {
        private InMemoryStoreBuilderImpl() {
        }

        @Override
        protected InMemoryStoreBuilderImpl self() {
            return this;
        }

        @Override
        public InMemoryStore build() {
            return new InMemoryStore(this);
        }
    }
}

