/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.impl.FileNames;
import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.FilenameStore;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.JacksonizedValue;
import io.xpipe.core.util.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonTypeName(value="file")
@JsonDeserialize(builder=FileStoreBuilderImpl.class)
public class FileStore
extends JacksonizedValue
implements FilenameStore,
StreamDataStore {
    FileSystemStore fileSystem;
    String path;

    public FileStore(FileSystemStore fileSystem, String path) {
        this.fileSystem = fileSystem;
        this.path = path;
    }

    public static FileStore local(Path p) {
        return new FileStore(new LocalStore(), p.toString());
    }

    public static FileStore local(String p) {
        return new FileStore(new LocalStore(), p);
    }

    public String getParent() {
        Matcher matcher = Pattern.compile("^(.+?)[^\\\\/]+$").matcher(this.path);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to determine parent of " + this.path);
        }
        return matcher.group(1);
    }

    public final boolean isLocal() {
        return this.fileSystem instanceof LocalStore;
    }

    @Override
    public void checkComplete() throws Exception {
        if (this.fileSystem == null) {
            throw new ValidationException("File system is missing");
        }
        if (this.path == null) {
            throw new ValidationException("File is missing");
        }
        if (!FileNames.isAbsolute(this.path)) {
            throw new ValidationException("File path is not absolute");
        }
    }

    @Override
    public InputStream openInput() throws Exception {
        return this.fileSystem.createFileSystem().open().openInput(this.path);
    }

    @Override
    public OutputStream openOutput() throws Exception {
        if (!this.fileSystem.createFileSystem().open().mkdirs(this.getParent())) {
            throw new IOException("Unable to create directory: " + this.getParent());
        }
        return this.fileSystem.createFileSystem().open().openOutput(this.path);
    }

    @Override
    public boolean canOpen() throws Exception {
        return this.fileSystem.createFileSystem().open().exists(this.path);
    }

    @Override
    public String getFileName() {
        String[] split = this.path.split("[\\\\/]");
        if (split.length == 0) {
            return "";
        }
        return split[split.length - 1];
    }

    protected FileStore(FileStoreBuilder<?, ?> b) {
        super(b);
        this.fileSystem = b.fileSystem;
        this.path = b.path;
    }

    public static FileStoreBuilder<?, ?> builder() {
        return new FileStoreBuilderImpl();
    }

    public FileSystemStore getFileSystem() {
        return this.fileSystem;
    }

    public String getPath() {
        return this.path;
    }

    public static abstract class FileStoreBuilder<C extends FileStore, B extends FileStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private FileSystemStore fileSystem;
        private String path;

        public B fileSystem(FileSystemStore fileSystem) {
            this.fileSystem = fileSystem;
            return (B)this.self();
        }

        public B path(String path) {
            this.path = path;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FileStore.FileStoreBuilder(super=" + super.toString() + ", fileSystem=" + String.valueOf(this.fileSystem) + ", path=" + this.path + ")";
        }
    }

    @JsonTypeName(value="file")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class FileStoreBuilderImpl
    extends FileStoreBuilder<FileStore, FileStoreBuilderImpl> {
        private FileStoreBuilderImpl() {
        }

        @Override
        protected FileStoreBuilderImpl self() {
            return this;
        }

        @Override
        public FileStore build() {
            return new FileStore(this);
        }
    }
}

