/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import java.util.Arrays;
import java.util.List;

public class FileNames {
    public static String toDirectory(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            return path;
        }
        if (path.contains("\\")) {
            return path + "\\";
        }
        return path + "/";
    }

    public static String getFileName(String file) {
        if (file.isEmpty()) {
            return "";
        }
        String[] split = file.split("[\\\\/]");
        if (split.length == 0) {
            return "";
        }
        List<String> components = Arrays.stream(split).filter(s -> !s.isEmpty()).toList();
        if (components.size() == 0) {
            return "";
        }
        return components.get(components.size() - 1);
    }

    public static String getExtension(String file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String name = FileNames.getFileName(file);
        String[] split = file.split("\\.");
        if (split.length == 0) {
            return null;
        }
        return split[split.length - 1];
    }

    public static String join(String ... parts) {
        String joined = String.join((CharSequence)"/", parts);
        return FileNames.normalize(joined);
    }

    public static boolean isAbsolute(String file) {
        if (!file.contains("/") && !file.contains("\\")) {
            return false;
        }
        return file.startsWith("/") || file.startsWith("~") || file.matches("^\\w:.*");
    }

    public static String getParent(String file) {
        if (FileNames.split(file).size() == 0) {
            return null;
        }
        if (FileNames.split(file).size() == 1) {
            return file.startsWith("/") && !file.equals("/") ? "/" : null;
        }
        return file.substring(0, file.length() - FileNames.getFileName(file).length() - 1);
    }

    public static boolean startsWith(String file, String start) {
        return FileNames.normalize(file).startsWith(FileNames.normalize(start));
    }

    public static String relativize(String from, String to) {
        return FileNames.normalize(to).substring(FileNames.normalize(from).length());
    }

    public static String normalize(String file) {
        boolean backslash = file.contains("\\");
        return backslash ? FileNames.toWindows(file) : FileNames.toUnix(file);
    }

    private static List<String> split(String file) {
        String[] split = file.split("[\\\\/]");
        return Arrays.stream(split).filter(s -> !s.isEmpty()).toList();
    }

    public static String toUnix(String file) {
        String joined = String.join((CharSequence)"/", FileNames.split(file));
        String prefix = file.startsWith("/") ? "/" : "";
        String suffix = file.endsWith("/") || file.endsWith("\\") ? "/" : "";
        return prefix + joined + suffix;
    }

    public static String toWindows(String file) {
        String suffix = file.endsWith("/") || file.endsWith("\\") ? "\\" : "";
        return String.join((CharSequence)"\\", FileNames.split(file)) + suffix;
    }
}

