/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.source.TableReadConnection;
import java.util.OptionalInt;

public class BufferedTableReadConnection
implements TableReadConnection {
    private final TableReadConnection connection;
    private final int maxCount;
    private int count = 0;
    private ArrayNode read;

    public BufferedTableReadConnection(TableReadConnection connection, int maxCount) throws Exception {
        this.connection = connection;
        this.maxCount = maxCount;
        this.read = connection.readRows(maxCount);
    }

    private TupleNode get() throws Exception {
        if (this.count == this.read.size()) {
            this.read = this.connection.readRows(this.maxCount);
        }
        if (this.read.size() == 0) {
            return null;
        }
        return this.read.at(this.count++).asTuple();
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public TupleType getDataType() {
        return this.connection.getDataType();
    }

    @Override
    public OptionalInt getRowCount() throws Exception {
        return this.connection.getRowCount();
    }

    @Override
    public void withRows(DataStructureNodeAcceptor<TupleNode> lineAcceptor) throws Exception {
        boolean returned;
        TupleNode node;
        while ((node = this.get()) != null && (returned = lineAcceptor.accept(node))) {
        }
    }

    @Override
    public boolean canRead() throws Exception {
        return this.connection.canRead();
    }
}

