/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.source.RawDataSource;
import io.xpipe.core.source.RawReadConnection;
import io.xpipe.core.source.RawWriteConnection;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.StreamDataStore;
import java.io.InputStream;
import java.io.OutputStream;

@JsonTypeName(value="binary")
@JsonDeserialize(builder=BinarySourceBuilderImpl.class)
public class BinarySource
extends RawDataSource<StreamDataStore> {
    @Override
    protected RawWriteConnection newWriteConnection(WriteMode mode) {
        return new RawWriteConnection(){
            private OutputStream out;

            @Override
            public void init() throws Exception {
                this.out = ((StreamDataStore)BinarySource.this.getStore()).openOutput();
            }

            @Override
            public void close() throws Exception {
                this.out.close();
            }

            @Override
            public void write(byte[] bytes) throws Exception {
                this.out.write(bytes);
            }
        };
    }

    @Override
    protected RawReadConnection newReadConnection() {
        return new RawReadConnection(){
            private InputStream inputStream;

            @Override
            public boolean canRead() throws Exception {
                return ((StreamDataStore)BinarySource.this.getStore()).canOpen();
            }

            @Override
            public void init() throws Exception {
                if (this.inputStream != null) {
                    throw new IllegalStateException("Already initialized");
                }
                this.inputStream = ((StreamDataStore)BinarySource.this.getStore()).openInput();
            }

            @Override
            public void close() throws Exception {
                this.inputStream.close();
            }

            @Override
            public byte[] readBytes(int max) throws Exception {
                return this.inputStream.readNBytes(max);
            }
        };
    }

    protected BinarySource(BinarySourceBuilder<?, ?> b) {
        super(b);
    }

    public static BinarySourceBuilder<?, ?> builder() {
        return new BinarySourceBuilderImpl();
    }

    @JsonTypeName(value="binary")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BinarySourceBuilderImpl
    extends BinarySourceBuilder<BinarySource, BinarySourceBuilderImpl> {
        private BinarySourceBuilderImpl() {
        }

        @Override
        protected BinarySourceBuilderImpl self() {
            return this;
        }

        @Override
        public BinarySource build() {
            return new BinarySource(this);
        }
    }

    public static abstract class BinarySourceBuilder<C extends BinarySource, B extends BinarySourceBuilder<C, B>>
    extends RawDataSource.RawDataSourceBuilder<StreamDataStore, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BinarySource.BinarySourceBuilder(super=" + super.toString() + ")";
        }
    }
}

