/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.dialog;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.xpipe.core.dialog.BaseQueryElement;
import io.xpipe.core.dialog.QueryConverter;

@JsonSerialize(as=BaseQueryElement.class)
public class QueryElement
extends BaseQueryElement {
    private final QueryConverter<?> converter;

    public <T> QueryElement(String description, boolean newLine, boolean required, boolean quiet, T value, QueryConverter<T> converter, boolean hidden) {
        super(description, newLine, required, hidden, quiet, value != null ? converter.toString(value) : null);
        this.converter = converter;
    }

    @Override
    public boolean apply(String value) {
        if (value == null) {
            return !this.isRequired() || this.value != null;
        }
        try {
            this.converter.convertFromString(value);
        }
        catch (Exception ex) {
            return false;
        }
        this.value = value;
        return true;
    }

    public <T> T getConvertedValue() {
        return (T)this.converter.convertFromString(this.value);
    }
}

