/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.dialog;

import io.xpipe.core.dialog.BaseQueryElement;
import io.xpipe.core.dialog.ChoiceElement;
import io.xpipe.core.dialog.Dialog;
import io.xpipe.core.dialog.DialogElement;
import java.util.LinkedHashMap;

public class DialogMapper {
    private final Dialog dialog;
    private final LinkedHashMap<String, String> map = new LinkedHashMap();

    public DialogMapper(Dialog dialog) {
        this.dialog = dialog;
        dialog.clearCompletion();
    }

    public LinkedHashMap<String, String> handle() throws Exception {
        DialogElement element = this.dialog.start();
        if (element == null) {
            return this.map;
        }
        this.handle(element);
        return this.map;
    }

    private void handle(DialogElement element) throws Exception {
        DialogElement newElement;
        String response = null;
        if (element instanceof ChoiceElement) {
            ChoiceElement c = (ChoiceElement)element;
            response = this.handleChoice(c);
        }
        if (element instanceof BaseQueryElement) {
            BaseQueryElement q = (BaseQueryElement)element;
            response = this.handleQuery(q);
        }
        if (element.equals(newElement = this.dialog.next(response))) {
            throw new IllegalStateException("Loop for key " + newElement.toDisplayString());
        }
        element = newElement;
        if (element != null) {
            this.handle(element);
        }
    }

    private String handleQuery(BaseQueryElement q) {
        this.map.put(q.getDescription(), q.getValue());
        return q.getValue();
    }

    private String handleChoice(ChoiceElement c) {
        this.map.put(c.getDescription(), c.getElements().get(c.getSelected()).getDescription());
        return String.valueOf(c.getSelected() + 1);
    }
}

