/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.typed;

import io.xpipe.core.data.generic.GenericDataStreamWriter;
import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeIO;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.node.ValueNode;
import io.xpipe.core.data.type.ArrayType;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.TupleType;
import java.io.IOException;
import java.io.OutputStream;

public class TypedDataStreamWriter {
    public static void writeStructure(OutputStream out, DataStructureNode node, DataType type) throws IOException {
        out.write(5);
        TypedDataStreamWriter.write(out, node, type);
    }

    private static void write(OutputStream out, DataStructureNode node, DataType type) throws IOException {
        if (type.isTuple() && node.isTuple()) {
            TypedDataStreamWriter.writeTuple(out, (TupleNode)node, (TupleType)type);
        } else if (node.isArray() && type.isArray()) {
            TypedDataStreamWriter.writeArray(out, (ArrayNode)node, (ArrayType)type);
        } else if (node.isValue() && type.isValue()) {
            TypedDataStreamWriter.writeValue(out, (ValueNode)node);
        } else if (type.isWildcard()) {
            GenericDataStreamWriter.writeStructure(out, node);
        } else {
            throw new IllegalStateException("Incompatible node and type");
        }
    }

    private static void writeValue(OutputStream out, ValueNode n) throws IOException {
        out.write(8);
        int length = DataStructureNodeIO.writeShort(out, n.getRawData().length);
        out.write(n.getRawData(), 0, length);
        DataStructureNodeIO.writeAttributes(out, n);
    }

    private static void writeTuple(OutputStream out, TupleNode tuple, TupleType type) throws IOException {
        if (tuple.size() != type.getSize()) {
            throw new IllegalArgumentException("Tuple size mismatch");
        }
        out.write(6);
        for (int i = 0; i < tuple.size(); ++i) {
            TypedDataStreamWriter.write(out, tuple.at(i), type.getTypes().get(i));
        }
        DataStructureNodeIO.writeAttributes(out, tuple);
    }

    private static void writeArray(OutputStream out, ArrayNode array, ArrayType type) throws IOException {
        out.write(7);
        DataStructureNodeIO.writeShort(out, array.size());
        for (int i = 0; i < array.size(); ++i) {
            TypedDataStreamWriter.write(out, array.at(i), type.getSharedType());
        }
        DataStructureNodeIO.writeAttributes(out, array);
    }
}

