/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.SimpleTupleNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class TupleNode
extends DataStructureNode {
    public static Builder builder() {
        return new Builder();
    }

    public static TupleNode of(List<DataStructureNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes must be not null");
        }
        return new SimpleTupleNode(null, nodes);
    }

    public static TupleNode of(List<String> names, List<? extends DataStructureNode> nodes) {
        if (names == null) {
            throw new IllegalArgumentException("Names must be not null");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes must be not null");
        }
        if (names.size() != nodes.size()) {
            throw new IllegalArgumentException("Names and nodes must have the same length");
        }
        return new SimpleTupleNode(names, nodes);
    }

    @Override
    public abstract TupleNode mutable();

    @Override
    public final boolean isTuple() {
        return true;
    }

    @Override
    public Stream<DataStructureNode> stream() {
        return this.getNodes().stream();
    }

    @Override
    public Spliterator<DataStructureNode> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    public Iterator<DataStructureNode> iterator() {
        return this.stream().iterator();
    }

    @Override
    public String toString(int indent) {
        String is = " ".repeat(indent);
        String start = "{\n";
        String kvs = this.getKeyValuePairs().stream().map(kv -> {
            if (kv.key() == null) {
                return is + " " + kv.value().toString(indent + 1) + "\n";
            }
            return is + " " + kv.key() + "=" + kv.value().toString(indent + 1) + "\n";
        }).collect(Collectors.joining());
        String end = is + "}";
        return start + kvs + end;
    }

    public boolean equals(Object o) {
        boolean toReturn;
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleNode)) {
            return false;
        }
        TupleNode that = (TupleNode)o;
        boolean bl = toReturn = this.getKeyNames().equals(that.getKeyNames()) && this.getNodes().equals(that.getNodes()) && Objects.equals(this.getMetaAttributes(), that.getMetaAttributes());
        if (!toReturn) {
            return false;
        }
        return toReturn;
    }

    public int hashCode() {
        return Objects.hash(this.getKeyNames(), this.getNodes(), this.getMetaAttributes());
    }

    public static class Builder {
        private final List<DataStructureNode.KeyValue> entries = new ArrayList<DataStructureNode.KeyValue>();

        public Builder add(String name, DataStructureNode node) {
            Objects.requireNonNull(node);
            this.entries.add(new DataStructureNode.KeyValue(name, node));
            return this;
        }

        public Builder add(DataStructureNode node) {
            Objects.requireNonNull(node);
            this.entries.add(new DataStructureNode.KeyValue(null, node));
            return this;
        }

        public TupleNode build() {
            boolean hasKeys = this.entries.stream().anyMatch(kv -> kv.key() != null);
            return hasKeys ? TupleNode.of(this.entries.stream().map(DataStructureNode.KeyValue::key).toList(), this.entries.stream().map(DataStructureNode.KeyValue::value).toList()) : TupleNode.of(this.entries.stream().map(DataStructureNode.KeyValue::value).toList());
        }
    }
}

