/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.TupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class LinkedTupleNode
extends TupleNode {
    private final List<TupleNode> tupleNodes;
    private List<DataStructureNode.KeyValue> joined;

    public LinkedTupleNode(List<TupleNode> tupleNodes) {
        this.tupleNodes = new ArrayList<TupleNode>(tupleNodes);
    }

    @Override
    public String keyNameAt(int index) {
        int list = this.getTupleNodeForIndex(index);
        return this.tupleNodes.get(list).keyNameAt(this.getLocalIndex(list, index));
    }

    @Override
    public List<DataStructureNode.KeyValue> getKeyValuePairs() {
        if (this.joined == null) {
            this.joined = new ArrayList<DataStructureNode.KeyValue>();
            for (TupleNode n : this.tupleNodes) {
                this.joined.addAll(n.getKeyValuePairs());
            }
            this.joined = Collections.unmodifiableList(this.joined);
        }
        return this.joined;
    }

    @Override
    public List<String> getKeyNames() {
        return this.getKeyValuePairs().stream().map(DataStructureNode.KeyValue::key).toList();
    }

    @Override
    public List<DataStructureNode> getNodes() {
        return this.getKeyValuePairs().stream().map(DataStructureNode.KeyValue::value).toList();
    }

    @Override
    protected String getName() {
        return "linked tuple node";
    }

    @Override
    public boolean isMutable() {
        return this.tupleNodes.stream().allMatch(DataStructureNode::isMutable);
    }

    @Override
    public DataStructureNode clear() {
        this.tupleNodes.forEach(DataStructureNode::clear);
        return this;
    }

    @Override
    public DataStructureNode set(int index, DataStructureNode node) {
        return super.set(index, node);
    }

    @Override
    public DataStructureNode put(String keyName, DataStructureNode node) {
        return super.put(keyName, node);
    }

    @Override
    public DataStructureNode remove(int index) {
        return super.remove(index);
    }

    @Override
    public DataStructureNode remove(String keyName) {
        return super.remove(keyName);
    }

    @Override
    public DataType determineDataType() {
        return TupleType.of(this.getKeyNames(), this.getNodes().stream().map(DataStructureNode::determineDataType).toList());
    }

    @Override
    public DataStructureNode at(int index) {
        int list = this.getTupleNodeForIndex(index);
        return this.tupleNodes.get(list).at(this.getLocalIndex(list, index));
    }

    @Override
    public DataStructureNode forKey(String name) {
        for (TupleNode ar : this.tupleNodes) {
            Optional<DataStructureNode> r = ar.forKeyIfPresent(name);
            if (!r.isPresent()) continue;
            return r.get();
        }
        throw new IllegalArgumentException("Invalid key " + name);
    }

    @Override
    public Optional<DataStructureNode> forKeyIfPresent(String name) {
        for (TupleNode ar : this.tupleNodes) {
            Optional<DataStructureNode> r = ar.forKeyIfPresent(name);
            if (!r.isPresent()) continue;
            return r;
        }
        return Optional.empty();
    }

    @Override
    public Stream<DataStructureNode> stream() {
        return this.getNodes().stream();
    }

    @Override
    public void forEach(Consumer<? super DataStructureNode> action) {
        for (TupleNode ar : this.tupleNodes) {
            ar.forEach(action);
        }
    }

    @Override
    public Spliterator<DataStructureNode> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    public Iterator<DataStructureNode> iterator() {
        return this.stream().iterator();
    }

    @Override
    public String toString() {
        return "LinkedTupleNode(" + this.size() + ")";
    }

    @Override
    public int size() {
        return this.tupleNodes.stream().mapToInt(DataStructureNode::size).sum();
    }

    private int getLocalIndex(int listIndex, int absIndex) {
        int current = 0;
        for (int i = 0; i < listIndex; ++i) {
            current += this.tupleNodes.get(i).size();
        }
        return absIndex - current;
    }

    private int getTupleNodeForIndex(int index) {
        int current = 0;
        for (TupleNode a : this.tupleNodes) {
            if (index < current + a.size()) {
                return this.tupleNodes.indexOf(a);
            }
            current += a.size();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public TupleNode mutable() {
        if (this.isMutable()) {
            return this;
        }
        return new LinkedTupleNode(this.tupleNodes.stream().map(n -> n.isMutable() ? n : n.mutable()).toList());
    }
}

