/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.generic;

import io.xpipe.core.data.generic.GenericAbstractReader;
import io.xpipe.core.data.generic.GenericArrayReader;
import io.xpipe.core.data.generic.GenericDataStreamCallback;
import io.xpipe.core.data.generic.GenericTupleReader;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.ValueNode;
import java.util.Map;

public class GenericDataStructureNodeReader
implements GenericDataStreamCallback {
    private DataStructureNode node;
    private GenericAbstractReader reader;

    public DataStructureNode create() {
        if (this.node == null) {
            throw new IllegalStateException("No node has been created yet");
        }
        this.reader = null;
        return this.node;
    }

    private boolean hasReader() {
        return this.reader != null;
    }

    @Override
    public void onName(String name) {
        if (this.hasReader()) {
            this.reader.onName(name);
            return;
        }
        throw new IllegalStateException("Expected node start but got name");
    }

    @Override
    public void onArrayStart(int length) {
        if (this.hasReader()) {
            this.reader.onArrayStart(length);
            return;
        }
        this.reader = GenericArrayReader.newReader(length);
    }

    @Override
    public void onArrayEnd(Map<Integer, String> metaAttributes) {
        if (!this.hasReader()) {
            throw new IllegalStateException("No array to close");
        }
        this.reader.onArrayEnd(metaAttributes);
        if (this.reader.isDone()) {
            this.node = this.reader.create();
            this.reader = null;
        }
    }

    @Override
    public void onTupleStart(int length) {
        if (this.hasReader()) {
            this.reader.onTupleStart(length);
            return;
        }
        this.reader = GenericTupleReader.newReader(length);
    }

    @Override
    public void onTupleEnd(Map<Integer, String> metaAttributes) {
        if (!this.hasReader()) {
            throw new IllegalStateException("No tuple to close");
        }
        this.reader.onTupleEnd(metaAttributes);
        if (this.reader.isDone()) {
            this.node = this.reader.create();
            this.reader = null;
        }
    }

    @Override
    public void onValue(byte[] value, Map<Integer, String> metaAttributes) {
        if (this.hasReader()) {
            this.reader.onValue(value, metaAttributes);
            return;
        }
        this.node = ValueNode.of(value).tag(metaAttributes);
    }
}

