/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.generic;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeIO;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.node.ValueNode;
import java.io.IOException;
import java.io.OutputStream;

public class GenericDataStreamWriter {
    public static void writeStructure(OutputStream out, DataStructureNode node) throws IOException {
        out.write(0);
        GenericDataStreamWriter.write(out, node);
    }

    private static void write(OutputStream out, DataStructureNode node) throws IOException {
        if (node.isTuple()) {
            GenericDataStreamWriter.writeTuple(out, (TupleNode)node);
        } else if (node.isArray()) {
            GenericDataStreamWriter.writeArray(out, (ArrayNode)node);
        } else if (node.isValue()) {
            GenericDataStreamWriter.writeValue(out, (ValueNode)node);
        } else {
            throw new IllegalStateException();
        }
    }

    private static void writeName(OutputStream out, String s) throws IOException {
        if (s != null) {
            out.write(4);
            DataStructureNodeIO.writeString(out, s);
        }
    }

    private static void writeTuple(OutputStream out, TupleNode tuple) throws IOException {
        out.write(1);
        DataStructureNodeIO.writeShort(out, tuple.size());
        for (int i = 0; i < tuple.size(); ++i) {
            GenericDataStreamWriter.writeName(out, tuple.keyNameAt(i));
            GenericDataStreamWriter.write(out, tuple.at(i));
        }
        DataStructureNodeIO.writeAttributes(out, tuple);
    }

    private static void writeArray(OutputStream out, ArrayNode array) throws IOException {
        out.write(2);
        DataStructureNodeIO.writeShort(out, array.size());
        for (int i = 0; i < array.size(); ++i) {
            GenericDataStreamWriter.write(out, array.at(i));
        }
        DataStructureNodeIO.writeAttributes(out, array);
    }

    private static void writeValue(OutputStream out, ValueNode n) throws IOException {
        out.write(3);
        int length = DataStructureNodeIO.writeShort(out, n.getRawData().length);
        out.write(n.getRawData(), 0, length);
        DataStructureNodeIO.writeAttributes(out, n);
    }
}

