/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.generic;

import io.xpipe.core.data.generic.GenericAbstractReader;
import io.xpipe.core.data.generic.GenericTupleReader;
import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.ValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericArrayReader
implements GenericAbstractReader {
    private boolean initialized;
    private List<DataStructureNode> nodes;
    private int length;
    private int currentIndex = 0;
    private GenericAbstractReader currentReader;
    private DataStructureNode created;

    public static GenericArrayReader newReader(int length) {
        GenericArrayReader ar = new GenericArrayReader();
        ar.onArrayStart(length);
        return ar;
    }

    private void init(int length) {
        this.length = length;
        this.nodes = new ArrayList<DataStructureNode>(length);
        this.initialized = true;
    }

    private void put(DataStructureNode node) {
        this.nodes.add(node);
        ++this.currentIndex;
    }

    @Override
    public void onName(String name) {
        if (this.hasReader()) {
            this.currentReader.onName(name);
            return;
        }
        throw new IllegalStateException("Expected array content but got a key name");
    }

    private boolean filled() {
        return this.currentIndex == this.length;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private boolean hasReader() {
        return this.currentReader != null;
    }

    @Override
    public void onArrayStart(int length) {
        if (this.hasReader()) {
            this.currentReader.onArrayStart(length);
            return;
        }
        if (!this.isInitialized()) {
            this.init(length);
            return;
        }
        this.currentReader = GenericArrayReader.newReader(length);
    }

    @Override
    public void onArrayEnd(Map<Integer, String> metaAttributes) {
        if (this.hasReader()) {
            this.currentReader.onArrayEnd(metaAttributes);
            if (this.currentReader.isDone()) {
                this.put(this.currentReader.create());
                this.currentReader = null;
            }
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected array start but got array end");
        }
        if (!this.filled()) {
            throw new IllegalStateException("Array ended but is not full yet");
        }
        this.created = ArrayNode.of(this.nodes);
    }

    @Override
    public void onTupleStart(int length) {
        if (this.hasReader()) {
            this.currentReader.onTupleStart(length);
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected array start but got tuple start");
        }
        if (this.filled()) {
            throw new IllegalStateException("Tuple is full but got another tuple");
        }
        this.currentReader = GenericTupleReader.newReader(length);
    }

    @Override
    public void onTupleEnd(Map<Integer, String> metaAttributes) {
        if (this.hasReader()) {
            this.currentReader.onTupleEnd(metaAttributes);
            if (this.currentReader.isDone()) {
                this.put(this.currentReader.create());
                this.currentReader = null;
            }
            return;
        }
        throw new IllegalStateException("Expected array end but got tuple end");
    }

    @Override
    public void onValue(byte[] value, Map<Integer, String> metaAttributes) {
        if (this.currentReader != null) {
            this.currentReader.onValue(value, metaAttributes);
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected array start but got value");
        }
        if (this.filled()) {
            throw new IllegalStateException("Array is full but got another value");
        }
        this.put(ValueNode.of(value).tag(metaAttributes));
    }

    @Override
    public boolean isDone() {
        return this.filled() && this.created != null;
    }

    @Override
    public DataStructureNode create() {
        if (!this.isDone()) {
            throw new IllegalStateException();
        }
        return ArrayNode.of(this.nodes);
    }
}

