/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.charsetter;

import java.util.Arrays;

public enum NewLine {
    LF("\n", "lf"),
    CRLF("\r\n", "crlf");

    private final String newLine;
    private final String id;

    private NewLine(String newLine, String id) {
        this.newLine = newLine;
        this.id = id;
    }

    public static NewLine platform() {
        return Arrays.stream(NewLine.values()).filter(n -> n.getNewLineString().equals(System.getProperty("line.separator"))).findFirst().orElseThrow();
    }

    public static NewLine byId(String id) {
        return Arrays.stream(NewLine.values()).filter(n -> n.getId().equalsIgnoreCase(id)).findFirst().orElseThrow();
    }

    public String getNewLineString() {
        return this.newLine;
    }

    public String getId() {
        return this.id;
    }
}

