/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.charsetter;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

public final class CharsetterContext {
    private final String systemCharsetName;
    private final Locale systemLocale;
    private final Locale appLocale;
    private final List<String> observedCharsets;

    public static CharsetterContext empty() {
        return new CharsetterContext(Charset.defaultCharset().name(), Locale.getDefault(), Locale.getDefault(), List.of());
    }

    public String getSystemCharsetName() {
        return this.systemCharsetName;
    }

    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    public Locale getAppLocale() {
        return this.appLocale;
    }

    public List<String> getObservedCharsets() {
        return this.observedCharsets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharsetterContext)) {
            return false;
        }
        CharsetterContext other = (CharsetterContext)o;
        String this$systemCharsetName = this.getSystemCharsetName();
        String other$systemCharsetName = other.getSystemCharsetName();
        if (this$systemCharsetName == null ? other$systemCharsetName != null : !this$systemCharsetName.equals(other$systemCharsetName)) {
            return false;
        }
        Locale this$systemLocale = this.getSystemLocale();
        Locale other$systemLocale = other.getSystemLocale();
        if (this$systemLocale == null ? other$systemLocale != null : !((Object)this$systemLocale).equals(other$systemLocale)) {
            return false;
        }
        Locale this$appLocale = this.getAppLocale();
        Locale other$appLocale = other.getAppLocale();
        if (this$appLocale == null ? other$appLocale != null : !((Object)this$appLocale).equals(other$appLocale)) {
            return false;
        }
        List<String> this$observedCharsets = this.getObservedCharsets();
        List<String> other$observedCharsets = other.getObservedCharsets();
        return !(this$observedCharsets == null ? other$observedCharsets != null : !((Object)this$observedCharsets).equals(other$observedCharsets));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $systemCharsetName = this.getSystemCharsetName();
        result = result * 59 + ($systemCharsetName == null ? 43 : $systemCharsetName.hashCode());
        Locale $systemLocale = this.getSystemLocale();
        result = result * 59 + ($systemLocale == null ? 43 : ((Object)$systemLocale).hashCode());
        Locale $appLocale = this.getAppLocale();
        result = result * 59 + ($appLocale == null ? 43 : ((Object)$appLocale).hashCode());
        List<String> $observedCharsets = this.getObservedCharsets();
        result = result * 59 + ($observedCharsets == null ? 43 : ((Object)$observedCharsets).hashCode());
        return result;
    }

    public String toString() {
        return "CharsetterContext(systemCharsetName=" + this.getSystemCharsetName() + ", systemLocale=" + String.valueOf(this.getSystemLocale()) + ", appLocale=" + String.valueOf(this.getAppLocale()) + ", observedCharsets=" + String.valueOf(this.getObservedCharsets()) + ")";
    }

    public CharsetterContext(String systemCharsetName, Locale systemLocale, Locale appLocale, List<String> observedCharsets) {
        this.systemCharsetName = systemCharsetName;
        this.systemLocale = systemLocale;
        this.appLocale = appLocale;
        this.observedCharsets = observedCharsets;
    }
}

