/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.charsetter;

import io.xpipe.core.charsetter.CharsetterContext;
import io.xpipe.core.charsetter.CharsetterUniverse;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.impl.FileStore;
import io.xpipe.core.store.ShellStore;
import io.xpipe.core.store.StreamDataStore;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class Charsetter {
    private static final int MAX_BYTES = 8192;
    public static Charsetter INSTANCE;
    private static CharsetterUniverse universe;

    protected Charsetter() {
    }

    protected static void checkInit() {
        if (universe == null) {
            throw new IllegalStateException("Charsetter not initialized");
        }
    }

    public static void init(CharsetterContext ctx) {
        universe = CharsetterUniverse.create(ctx);
    }

    public static Charsetter get() {
        return INSTANCE;
    }

    private static int count(byte[] outerArray, byte[] smallerArray) {
        int count = 0;
        for (int i = 0; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            ++count;
        }
        return count;
    }

    public BufferedReader reader(StreamDataStore store, StreamCharset charset) throws Exception {
        return this.reader(store.openBufferedInput(), charset);
    }

    public OutputStreamWriter writer(StreamDataStore store, StreamCharset charset) throws Exception {
        OutputStreamWriter out = new OutputStreamWriter(store.openOutput(), charset.getCharset());
        return out;
    }

    public BufferedReader reader(InputStream stream, StreamCharset charset) throws Exception {
        byte[] bom;
        if (charset.hasByteOrderMark() && (bom = stream.readNBytes(charset.getByteOrderMark().length)).length != 0 && !Arrays.equals(bom, charset.getByteOrderMark())) {
            throw new IllegalStateException("Charset does not match: " + charset.toString());
        }
        return new BufferedReader(new InputStreamReader(stream, charset.getCharset()));
    }

    public abstract Result read(FailableSupplier<InputStream, Exception> var1, FailableConsumer<InputStreamReader, Exception> var2) throws Exception;

    public Result detect(StreamDataStore store) throws Exception {
        FileStore fileStore;
        Object object;
        Result result = new Result(null, null);
        if (store.canOpen()) {
            try (InputStream inputStream = store.openBufferedInput();){
                StreamCharset detected = null;
                object = StreamCharset.COMMON.iterator();
                while (object.hasNext()) {
                    StreamCharset charset = (StreamCharset)object.next();
                    if (!charset.hasByteOrderMark()) continue;
                    inputStream.mark(charset.getByteOrderMark().length);
                    byte[] bom = inputStream.readNBytes(charset.getByteOrderMark().length);
                    inputStream.reset();
                    if (!Arrays.equals(bom, charset.getByteOrderMark())) continue;
                    detected = charset;
                    break;
                }
                byte[] bytes = inputStream.readNBytes(8192);
                if (detected == null) {
                    detected = StreamCharset.get(this.inferCharset(bytes), false);
                }
                NewLine nl = this.inferNewLine(bytes);
                result = new Result(detected, nl);
            }
        }
        if (store instanceof FileStore && (object = (fileStore = (FileStore)store).getFileSystem()) instanceof ShellStore) {
            ShellStore m = (ShellStore)object;
            if (result.getNewLine() == null) {
                result = new Result(result.getCharset(), m.getShellType() != null ? m.getShellType().getNewLine() : null);
            }
        }
        if (result.getCharset() == null) {
            result = new Result(StreamCharset.UTF8, result.getNewLine());
        }
        if (result.getNewLine() == null) {
            result = new Result(result.getCharset(), NewLine.platform());
        }
        return result;
    }

    public NewLine inferNewLine(byte[] content) {
        HashMap<NewLine, Integer> count = new HashMap<NewLine, Integer>();
        for (NewLine nl : NewLine.values()) {
            byte[] nlBytes = nl.getNewLineString().getBytes(StandardCharsets.UTF_8);
            count.put(nl, Charsetter.count(content, nlBytes));
        }
        if (count.values().stream().allMatch(v -> v == 0)) {
            return null;
        }
        return (NewLine)((Object)count.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue)).orElseThrow().getKey());
    }

    public Charset inferCharset(byte[] content) {
        Charsetter.checkInit();
        for (Charset c : universe.getCharsets()) {
            CharsetDecoder decoder = c.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer byteBuf = ByteBuffer.wrap(content);
            CharBuffer charBuf = CharBuffer.allocate(byteBuf.capacity() * 2);
            CoderResult coderResult = decoder.decode(byteBuf, charBuf, false);
            if (coderResult != null && coderResult.isError()) continue;
            return c;
        }
        return StandardCharsets.UTF_8;
    }

    public static final class Result {
        private final StreamCharset charset;
        private final NewLine newLine;

        public Result(StreamCharset charset, NewLine newLine) {
            this.charset = charset;
            this.newLine = newLine;
        }

        public StreamCharset getCharset() {
            return this.charset;
        }

        public NewLine getNewLine() {
            return this.newLine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            StreamCharset this$charset = this.getCharset();
            StreamCharset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            NewLine this$newLine = this.getNewLine();
            NewLine other$newLine = other.getNewLine();
            return !(this$newLine == null ? other$newLine != null : !((Object)((Object)this$newLine)).equals((Object)other$newLine));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StreamCharset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            NewLine $newLine = this.getNewLine();
            result = result * 59 + ($newLine == null ? 43 : ((Object)((Object)$newLine)).hashCode());
            return result;
        }

        public String toString() {
            return "Charsetter.Result(charset=" + String.valueOf(this.getCharset()) + ", newLine=" + String.valueOf((Object)this.getNewLine()) + ")";
        }
    }

    @FunctionalInterface
    public static interface FailableConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface FailableSupplier<R, E extends Throwable> {
        public R get() throws E;
    }
}

