/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.process.CommandProcessControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellProcessControl;
import java.util.List;

public class XPipeInstallation {
    public static String createExternalAsyncLaunchCommand(String installationBase, String arguments) {
        String suffix;
        String string = suffix = arguments != null ? arguments : "";
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return "nohup \"" + installationBase + "/app/bin/xpiped\" --external & disown" + suffix;
        }
        return FileNames.join(installationBase, XPipeInstallation.getDaemonExecutablePath(OsType.getLocal())) + suffix;
    }

    public static String createExternalLaunchCommand(String command, String arguments) {
        String suffix = arguments != null ? arguments : "";
        return "\"" + command + "\" --external" + suffix;
    }

    public static String getInstallationBasePathForCLI(ShellProcessControl p, String cliExecutable) throws Exception {
        String defaultInstallation = XPipeInstallation.getDefaultInstallationBasePath(p, true);
        if (cliExecutable == null) {
            return defaultInstallation;
        }
        if (p.getOsType().equals(OsType.LINUX) && cliExecutable.equals("/usr/bin/xpipe")) {
            return defaultInstallation;
        }
        if (FileNames.startsWith(cliExecutable, defaultInstallation)) {
            return defaultInstallation;
        }
        return FileNames.getParent(FileNames.getParent(cliExecutable));
    }

    public static String queryInstallationVersion(ShellProcessControl p, String exec) throws Exception {
        String string;
        block8: {
            CommandProcessControl c = p.command(List.of(exec, "version")).start();
            try {
                string = c.readOrThrow();
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessOutputException ex) {
                    return "?";
                }
            }
            c.close();
        }
        return string;
    }

    public static String getInstallationExecutable(ShellProcessControl p, String installation) throws Exception {
        String executable = XPipeInstallation.getDaemonExecutablePath(p.getOsType());
        String file = FileNames.join(installation, executable);
        return file;
    }

    public static String getDataBasePath(ShellProcessControl p) throws Exception {
        if (p.getOsType().equals(OsType.WINDOWS)) {
            String base = p.executeStringSimpleCommand(p.getShellType().getPrintVariableCommand("userprofile"));
            return FileNames.join(base, ".xpipe");
        }
        return FileNames.join("~", ".xpipe");
    }

    public static String getDefaultInstallationBasePath() throws Exception {
        try (ShellProcessControl pc = new LocalStore().create().start();){
            String string = XPipeInstallation.getDefaultInstallationBasePath(pc, true);
            return string;
        }
    }

    public static String getDefaultInstallationBasePath(ShellProcessControl p, boolean acceptPortable) throws Exception {
        String customHome;
        if (acceptPortable && !(customHome = p.executeStringSimpleCommand(p.getShellType().getPrintVariableCommand("XPIPE_HOME"))).isEmpty()) {
            return customHome;
        }
        String path = null;
        if (p.getOsType().equals(OsType.WINDOWS)) {
            String base = p.executeStringSimpleCommand(p.getShellType().getPrintVariableCommand("LOCALAPPDATA"));
            path = FileNames.join(base, "X-Pipe");
        } else {
            path = "/opt/xpipe";
        }
        return path;
    }

    public static String getDaemonDebugScriptPath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug.bat");
        }
        return FileNames.join("app", "scripts", "xpiped_debug.sh");
    }

    public static String getDaemonDebugAttachScriptPath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug_attach.bat");
        }
        return FileNames.join("app", "scripts", "xpiped_debug_attach.sh");
    }

    public static String getDaemonExecutablePath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "xpiped.exe");
        }
        return FileNames.join("app", "bin", "xpiped");
    }
}

