/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;

public class SecretValue {
    String value;

    public static SecretValue create(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return new SecretValue(s);
        }
        return new SecretValue(Base64.getEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8)));
    }

    public void withSecretValue(Consumer<char[]> chars) {
        byte[] bytes = Base64.getDecoder().decode(this.value);
        CharBuffer buffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
        char[] array = buffer.array();
        chars.accept(array);
        Arrays.fill(array, '\u0000');
    }

    public String toString() {
        return "<secret>";
    }

    public String getEncryptedValue() {
        return this.value;
    }

    public String getSecretValue() {
        if (this.value.length() < 2) {
            return this.value;
        }
        try {
            return new String(Base64.getDecoder().decode(this.value), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public SecretValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretValue)) {
            return false;
        }
        SecretValue other = (SecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

