/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import io.xpipe.core.data.type.ArrayType;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.type.ValueType;
import io.xpipe.core.data.type.WildcardType;
import io.xpipe.core.dialog.BaseQueryElement;
import io.xpipe.core.dialog.BusyElement;
import io.xpipe.core.dialog.ChoiceElement;
import io.xpipe.core.dialog.HeaderElement;
import io.xpipe.core.impl.CollectionEntryDataStore;
import io.xpipe.core.impl.LocalDirectoryDataStore;
import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.impl.NamedStore;
import io.xpipe.core.impl.StdinDataStore;
import io.xpipe.core.impl.StdoutDataStore;
import io.xpipe.core.process.ShellTypes;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.util.SecretValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class CoreJacksonModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        context.registerSubtypes(new NamedType[]{new NamedType(StdinDataStore.class), new NamedType(StdoutDataStore.class), new NamedType(LocalDirectoryDataStore.class), new NamedType(CollectionEntryDataStore.class), new NamedType(LocalStore.class), new NamedType(NamedStore.class), new NamedType(ValueType.class), new NamedType(TupleType.class), new NamedType(ArrayType.class), new NamedType(WildcardType.class), new NamedType(ShellTypes.Cmd.class), new NamedType(ShellTypes.PowerShell.class), new NamedType(ShellTypes.PosixBase.class), new NamedType(BaseQueryElement.class), new NamedType(ChoiceElement.class), new NamedType(BusyElement.class), new NamedType(HeaderElement.class)});
        this.addSerializer(Charset.class, new CharsetSerializer());
        this.addDeserializer(Charset.class, new CharsetDeserializer());
        this.addSerializer(Path.class, new LocalPathSerializer());
        this.addDeserializer(Path.class, new LocalPathDeserializer());
        this.addSerializer(SecretValue.class, new SecretSerializer());
        this.addDeserializer(SecretValue.class, new SecretDeserializer());
        this.addSerializer(DataSourceReference.class, new DataSourceReferenceSerializer());
        this.addDeserializer(DataSourceReference.class, new DataSourceReferenceDeserializer());
        context.setMixInAnnotations(Throwable.class, ThrowableTypeMixIn.class);
        context.setMixInAnnotations(DataSourceReference.class, DataSourceReferenceTypeMixIn.class);
        context.addSerializers((Serializers)this._serializers);
        context.addDeserializers((Deserializers)this._deserializers);
        try {
            Class.forName("io.xpipe.extension.ExtensionException");
        }
        catch (ClassNotFoundException e) {
            this.addSerializer(DataSource.class, new NullSerializer(this));
            this.addDeserializer(DataSource.class, new NullDeserializer());
        }
    }

    public static class CharsetSerializer
    extends JsonSerializer<Charset> {
        public void serialize(Charset value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name());
        }
    }

    public static class CharsetDeserializer
    extends JsonDeserializer<Charset> {
        public Charset deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Charset.forName(p.getValueAsString());
        }
    }

    public static class LocalPathSerializer
    extends JsonSerializer<Path> {
        public void serialize(Path value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }
    }

    public static class LocalPathDeserializer
    extends JsonDeserializer<Path> {
        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Path.of(p.getValueAsString(), new String[0]);
        }
    }

    public static class SecretSerializer
    extends JsonSerializer<SecretValue> {
        public void serialize(SecretValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getEncryptedValue());
        }
    }

    public static class SecretDeserializer
    extends JsonDeserializer<SecretValue> {
        public SecretValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new SecretValue(p.getValueAsString());
        }
    }

    public static class DataSourceReferenceSerializer
    extends JsonSerializer<DataSourceReference> {
        public void serialize(DataSourceReference value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toRefString());
        }
    }

    public static class DataSourceReferenceDeserializer
    extends JsonDeserializer<DataSourceReference> {
        public DataSourceReference deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return DataSourceReference.parse(p.getValueAsString());
        }
    }

    @JsonSerialize(as=Throwable.class)
    public static abstract class ThrowableTypeMixIn {
        @JsonIdentityInfo(generator=ObjectIdGenerators.StringIdGenerator.class, property="$id")
        private Throwable cause;
    }

    @JsonSerialize(as=DataSourceReference.class)
    public static abstract class DataSourceReferenceTypeMixIn {
    }

    public class NullSerializer
    extends JsonSerializer<Object> {
        public NullSerializer(CoreJacksonModule this$0) {
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNull();
        }
    }

    public static class NullDeserializer
    extends JsonDeserializer<DataSource> {
        public DataSource deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return null;
        }
    }
}

