/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellProcessControl;
import io.xpipe.core.process.ShellType;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.MachineStore;

public interface ShellStore
extends DataStore {
    public static MachineStore local() {
        return new LocalStore();
    }

    public static boolean isLocal(ShellStore s) {
        return s instanceof LocalStore;
    }

    public ShellProcessControl create();

    default public ShellType determineType() throws Exception {
        try (ShellProcessControl pc = this.create().start();){
            ShellType shellType = pc.getShellType();
            return shellType;
        }
    }

    @Override
    default public void validate() throws Exception {
        ShellProcessControl pc = this.create().start();
        if (pc != null) {
            pc.close();
        }
    }

    default public String queryMachineName() throws Exception {
        try (ShellProcessControl pc = this.create().start();){
            OsType operatingSystem = pc.getOsType();
            String string = operatingSystem.determineOperatingSystemName(pc);
            return string;
        }
    }
}

