/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.CommandProcessControl;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.ShellStore;
import java.io.InputStream;
import java.io.OutputStream;

public interface MachineStore
extends FileSystemStore,
ShellStore {
    default public boolean isLocal() {
        return false;
    }

    @Override
    default public InputStream openInput(String file) throws Exception {
        return this.create().command(proc -> proc.getShellType().createFileReadCommand(proc.getOsType().normalizeFileName(file))).startExternalStdout();
    }

    @Override
    default public OutputStream openOutput(String file) throws Exception {
        return this.create().command(proc -> proc.getShellType().createFileWriteCommand(proc.getOsType().normalizeFileName(file))).startExternalStdin();
    }

    @Override
    default public boolean exists(String file) throws Exception {
        try (CommandProcessControl pc = this.create().command(proc -> proc.getShellType().createFileExistsCommand(proc.getOsType().normalizeFileName(file))).start();){
            boolean bl = pc.discardAndCheckExit();
            return bl;
        }
    }

    @Override
    default public boolean mkdirs(String file) throws Exception {
        try (CommandProcessControl pc = this.create().command(proc -> proc.getShellType().flatten(proc.getShellType().createMkdirsCommand(proc.getOsType().normalizeFileName(file)))).start();){
            boolean bl = pc.discardAndCheckExit();
            return bl;
        }
    }
}

