/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.StructureReadConnection;
import io.xpipe.core.source.StructureWriteConnection;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataStore;

public abstract class StructureDataSource<DS extends DataStore>
extends DataSource<DS> {
    @Override
    public DataSourceType getType() {
        return DataSourceType.STRUCTURE;
    }

    private int countEntries(DataStructureNode n) {
        if (n.isValue()) {
            return 1;
        }
        int c = 0;
        for (int i = 0; i < n.size(); ++i) {
            c += this.countEntries(n.at(i));
        }
        return c;
    }

    @Override
    public final StructureReadConnection openReadConnection() throws Exception {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException();
        }
        return this.newReadConnection();
    }

    @Override
    public final StructureWriteConnection openWriteConnection(WriteMode mode) throws Exception {
        StructureWriteConnection con = this.newWriteConnection(mode);
        if (con == null) {
            throw new UnsupportedOperationException(mode.getId());
        }
        return con;
    }

    protected abstract StructureWriteConnection newWriteConnection(WriteMode var1);

    protected abstract StructureReadConnection newReadConnection();

    protected StructureDataSource(StructureDataSourceBuilder<DS, ?, ?> b) {
        super(b);
    }

    public static abstract class StructureDataSourceBuilder<DS extends DataStore, C extends StructureDataSource<DS>, B extends StructureDataSourceBuilder<DS, C, B>>
    extends DataSource.DataSourceBuilder<DS, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "StructureDataSource.StructureDataSourceBuilder(super=" + super.toString() + ")";
        }
    }
}

