/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.source.DataSourceId;
import java.util.Objects;
import lombok.NonNull;

public interface DataSourceReference {
    public static DataSourceReference latest() {
        return new Latest();
    }

    public static DataSourceReference name(String name) {
        return new Name(name);
    }

    public static DataSourceReference id(String id) {
        return new Id(DataSourceId.fromString(id));
    }

    public static DataSourceReference id(DataSourceId id) {
        return new Id(id);
    }

    public static DataSourceReference parse(String s) {
        if (s == null || s.trim().length() == 0) {
            return new Latest();
        }
        if (s.contains(":")) {
            return new Id(DataSourceId.fromString(s));
        }
        return new Name(s.trim());
    }

    public Type getType();

    public DataSourceId getId();

    public String getName();

    public String toRefString();

    public String toString();

    public static class Latest
    implements DataSourceReference {
        @Override
        public String toRefString() {
            return "";
        }

        @Override
        public String toString() {
            return "latest";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public Type getType() {
            return Type.LATEST;
        }

        @Override
        public DataSourceId getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Name
    implements DataSourceReference {
        @NonNull
        private final String value;

        @Override
        public String toString() {
            return this.toRefString();
        }

        @Override
        public String toRefString() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name n = (Name)o;
            return this.value.equals(n.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public Type getType() {
            return Type.NAME;
        }

        @Override
        public DataSourceId getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.value;
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        public Name(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }
    }

    public static final class Id
    implements DataSourceReference {
        @NonNull
        private final DataSourceId value;

        @Override
        public String toString() {
            return this.toRefString();
        }

        @Override
        public String toRefString() {
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.value.equals(id.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public Type getType() {
            return Type.ID;
        }

        @Override
        public DataSourceId getId() {
            return this.value;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public DataSourceId getValue() {
            return this.value;
        }

        public Id(@NonNull DataSourceId value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }
    }

    public static enum Type {
        ID,
        NAME,
        LATEST;

    }
}

