/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import com.fasterxml.jackson.annotation.JsonCreator;

public class DataSourceId {
    public static final char SEPARATOR = ':';
    private final String collectionName;
    private final String entryName;

    @JsonCreator
    private DataSourceId(String collectionName, String entryName) {
        this.collectionName = collectionName;
        this.entryName = entryName;
    }

    public static String cleanString(String input) {
        String replaced = input.replaceAll(":", "");
        return replaced.length() == 0 ? "-" : replaced;
    }

    public static DataSourceId create(String collectionName, String entryName) {
        if (collectionName != null && collectionName.trim().length() == 0) {
            throw new IllegalArgumentException("Trimmed collection name is empty");
        }
        if (collectionName != null && collectionName.contains(":")) {
            throw new IllegalArgumentException("Separator character : is not allowed in the collection name");
        }
        if (entryName == null) {
            throw new IllegalArgumentException("Collection name is null");
        }
        if (entryName.trim().length() == 0) {
            throw new IllegalArgumentException("Trimmed entry name is empty");
        }
        if (entryName.contains(":")) {
            throw new IllegalArgumentException("Separator character : is not allowed in the entry name");
        }
        return new DataSourceId(collectionName, entryName);
    }

    public static DataSourceId fromString(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String is null");
        }
        String[] split = s.split(String.valueOf(':'));
        if (split.length != 2) {
            throw new IllegalArgumentException("Data source id must contain exactly one :");
        }
        String cn = split[0].trim().toLowerCase();
        String en = split[1].trim().toLowerCase();
        String string = cn = cn.isEmpty() ? null : cn;
        if (en.length() == 0) {
            throw new IllegalArgumentException("Entry name must not be empty");
        }
        return new DataSourceId(cn, en);
    }

    public String toString() {
        return (this.collectionName != null ? this.collectionName.toLowerCase() : "") + ":" + this.entryName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceId)) {
            return false;
        }
        DataSourceId other = (DataSourceId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$entryName = this.getEntryName();
        String other$entryName = other.getEntryName();
        return !(this$entryName == null ? other$entryName != null : !this$entryName.equals(other$entryName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $entryName = this.getEntryName();
        result = result * 59 + ($entryName == null ? 43 : $entryName.hashCode());
        return result;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getEntryName() {
        return this.entryName;
    }
}

