/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.source.CollectionReadConnection;
import io.xpipe.core.source.CollectionWriteConnection;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class CollectionDataSource<DS extends DataStore>
extends DataSource<DS> {
    private final Map<String, String> preferredProviders;

    @Override
    public DataSourceType getType() {
        return DataSourceType.COLLECTION;
    }

    public CollectionDataSource<DS> annotate(String file, String provider) {
        this.preferredProviders.put(file, provider);
        return this;
    }

    public CollectionDataSource<DS> annotate(Map<String, String> preferredProviders) {
        this.preferredProviders.putAll(preferredProviders);
        return this;
    }

    @Override
    public final CollectionReadConnection openReadConnection() throws Exception {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException();
        }
        return this.newReadConnection();
    }

    @Override
    public final CollectionWriteConnection openWriteConnection(WriteMode mode) throws Exception {
        CollectionWriteConnection con = this.newWriteConnection(mode);
        if (con == null) {
            throw new UnsupportedOperationException(mode.getId());
        }
        return con;
    }

    protected abstract CollectionWriteConnection newWriteConnection(WriteMode var1);

    protected abstract CollectionReadConnection newReadConnection();

    protected CollectionDataSource(CollectionDataSourceBuilder<DS, ?, ?> b) {
        super(b);
        Map<Object, Object> preferredProviders;
        switch (b.preferredProviders$key == null ? 0 : b.preferredProviders$key.size()) {
            case 0: {
                preferredProviders = Collections.emptyMap();
                break;
            }
            case 1: {
                preferredProviders = Collections.singletonMap(b.preferredProviders$key.get(0), b.preferredProviders$value.get(0));
                break;
            }
            default: {
                preferredProviders = new LinkedHashMap(b.preferredProviders$key.size() < 0x40000000 ? 1 + b.preferredProviders$key.size() + (b.preferredProviders$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.preferredProviders$key.size(); ++$i) {
                    preferredProviders.put(b.preferredProviders$key.get($i), b.preferredProviders$value.get($i));
                }
                preferredProviders = Collections.unmodifiableMap(preferredProviders);
            }
        }
        this.preferredProviders = preferredProviders;
    }

    public static abstract class CollectionDataSourceBuilder<DS extends DataStore, C extends CollectionDataSource<DS>, B extends CollectionDataSourceBuilder<DS, C, B>>
    extends DataSource.DataSourceBuilder<DS, C, B> {
        private ArrayList<String> preferredProviders$key;
        private ArrayList<String> preferredProviders$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B preferredProvider(String preferredProviderKey, String preferredProviderValue) {
            if (this.preferredProviders$key == null) {
                this.preferredProviders$key = new ArrayList();
                this.preferredProviders$value = new ArrayList();
            }
            this.preferredProviders$key.add(preferredProviderKey);
            this.preferredProviders$value.add(preferredProviderValue);
            return (B)this.self();
        }

        public B preferredProviders(Map<? extends String, ? extends String> preferredProviders) {
            if (preferredProviders == null) {
                throw new NullPointerException("preferredProviders cannot be null");
            }
            if (this.preferredProviders$key == null) {
                this.preferredProviders$key = new ArrayList();
                this.preferredProviders$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : preferredProviders.entrySet()) {
                this.preferredProviders$key.add($lombokEntry.getKey());
                this.preferredProviders$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearPreferredProviders() {
            if (this.preferredProviders$key != null) {
                this.preferredProviders$key.clear();
                this.preferredProviders$value.clear();
            }
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CollectionDataSource.CollectionDataSourceBuilder(super=" + super.toString() + ", preferredProviders$key=" + String.valueOf(this.preferredProviders$key) + ", preferredProviders$value=" + String.valueOf(this.preferredProviders$value) + ")";
        }
    }
}

