/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.process.ShellProcessControl;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface ShellType {
    public String getScriptFileEnding();

    default public String commandWithVariable(String key, String value, String command) {
        return this.joinCommands(this.getSetVariableCommand(key, value), command);
    }

    public String getPauseCommand();

    public String createInitFileContent(String var1);

    public String getTerminalFileOpenCommand(String var1);

    default public String flatten(List<String> command) {
        return command.stream().map(s -> !(!s.contains(" ") || s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) ? "\"" + s + "\"" : s).collect(Collectors.joining(" "));
    }

    default public String joinCommands(String ... s) {
        return String.join((CharSequence)this.getConcatenationOperator(), s);
    }

    public void elevate(ShellProcessControl var1, String var2, String var3) throws Exception;

    default public String getExitCommand() {
        return "exit";
    }

    public String getExitCodeVariable();

    default public String getConcatenationOperator() {
        return ";";
    }

    default public String getOrConcatenationOperator() {
        return "||";
    }

    public String getMakeExecutableCommand(String var1);

    default public String getScriptEchoCommand(String s) {
        return this.getEchoCommand(s, false);
    }

    public String getEchoCommand(String var1, boolean var2);

    public String queryShellProcessId(ShellProcessControl var1) throws Exception;

    public String getSetVariableCommand(String var1, String var2);

    default public String getPrintVariableCommand(String name) {
        return this.getPrintVariableCommand("", name);
    }

    public String getPrintVariableCommand(String var1, String var2);

    public String getNormalOpenCommand();

    public String executeCommandWithShell(String var1);

    public List<String> executeCommandListWithShell(String var1);

    public List<String> createMkdirsCommand(String var1);

    public String createFileReadCommand(String var1);

    public String createFileWriteCommand(String var1);

    public String createFileDeleteCommand(String var1);

    public String createFileExistsCommand(String var1);

    public String createWhichCommand(String var1);

    public Charset determineCharset(ShellProcessControl var1) throws Exception;

    public NewLine getNewLine();

    public String getName();

    public String getDisplayName();

    public String getExecutable();

    public boolean echoesInput();
}

