/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandProcessControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ShellType;
import io.xpipe.core.util.SecretValue;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public interface ShellProcessControl
extends ProcessControl {
    @Override
    default public String prepareTerminalOpen() throws Exception {
        return this.prepareTerminalOpen(null);
    }

    public String prepareTerminalOpen(String var1) throws Exception;

    default public String executeStringSimpleCommand(String command) throws Exception {
        try (CommandProcessControl c = this.command(command).start();){
            String string = c.readOrThrow();
            return string;
        }
    }

    default public boolean executeBooleanSimpleCommand(String command) throws Exception {
        try (CommandProcessControl c = this.command(command).start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    default public void executeSimpleCommand(String command) throws Exception {
        try (CommandProcessControl c = this.command(command).start();){
            c.discardOrThrow();
        }
    }

    default public String executeStringSimpleCommand(ShellType type, String command) throws Exception {
        try (ShellProcessControl sub = this.subShell(type).start();){
            String string = sub.executeStringSimpleCommand(command);
            return string;
        }
    }

    public void restart() throws Exception;

    public boolean isLocal();

    public OsType getOsType();

    public ShellProcessControl elevated(Predicate<ShellProcessControl> var1);

    public ShellProcessControl elevation(SecretValue var1);

    public SecretValue getElevationPassword();

    default public ShellProcessControl subShell(@NonNull ShellType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.subShell(p -> type.getNormalOpenCommand(), (shellProcessControl, s) -> s == null ? type.getNormalOpenCommand() : type.executeCommandWithShell((String)s)).elevation(this.getElevationPassword());
    }

    default public ShellProcessControl subShell(@NonNull List<String> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.subShell(shellProcessControl -> shellProcessControl.getShellType().flatten(command), null);
    }

    default public ShellProcessControl subShell(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.subShell(processControl -> command, null);
    }

    public ShellProcessControl subShell(@NonNull Function<ShellProcessControl, String> var1, BiFunction<ShellProcessControl, String, String> var2);

    public void executeCommand(String var1) throws Exception;

    @Override
    public ShellProcessControl start() throws Exception;

    public CommandProcessControl command(Function<ShellProcessControl, String> var1);

    public CommandProcessControl command(Function<ShellProcessControl, String> var1, Function<ShellProcessControl, String> var2);

    default public CommandProcessControl command(String command) {
        return this.command((ShellProcessControl shellProcessControl) -> command);
    }

    default public CommandProcessControl command(List<String> command) {
        return this.command((ShellProcessControl shellProcessControl) -> shellProcessControl.getShellType().flatten(command));
    }

    public void exitAndWait() throws IOException;
}

