/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandProcessControl;
import io.xpipe.core.process.PropertiesFormatsParser;
import io.xpipe.core.process.ShellProcessControl;
import io.xpipe.core.process.ShellTypes;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public interface OsType {
    public static final Windows WINDOWS = new Windows();
    public static final Linux LINUX = new Linux();
    public static final Mac MAC = new Mac();

    public String getName();

    public String getTempDirectory(ShellProcessControl var1) throws Exception;

    public String normalizeFileName(String var1);

    public Map<String, String> getProperties(ShellProcessControl var1) throws Exception;

    public String determineOperatingSystemName(ShellProcessControl var1) throws Exception;

    public static OsType getLocal() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MAC;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nux")) {
            return LINUX;
        }
        throw new UnsupportedOperationException("Unknown operating system");
    }

    public Path getBaseInstallPath();

    public UUID getSystemUUID(ShellProcessControl var1) throws Exception;

    public static class Mac
    implements OsType {
        @Override
        public String getTempDirectory(ShellProcessControl pc) throws Exception {
            return pc.executeStringSimpleCommand(pc.getShellType().getPrintVariableCommand("TEMP"));
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"/", file.split("[\\\\/]+"));
        }

        @Override
        public String getName() {
            return "Mac";
        }

        @Override
        public Map<String, String> getProperties(ShellProcessControl pc) throws Exception {
            return null;
        }

        @Override
        public String determineOperatingSystemName(ShellProcessControl pc) throws Exception {
            return null;
        }

        @Override
        public Path getBaseInstallPath() {
            return Path.of(System.getProperty("user.home"), "Application Support", "X-Pipe");
        }

        @Override
        public UUID getSystemUUID(ShellProcessControl pc) throws Exception {
            return null;
        }
    }

    public static class Windows
    implements OsType {
        @Override
        public String getName() {
            return "Windows";
        }

        @Override
        public String getTempDirectory(ShellProcessControl pc) throws Exception {
            return pc.executeStringSimpleCommand(ShellTypes.CMD, ShellTypes.CMD.getPrintVariableCommand("TEMP"));
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"\\", file.split("[\\\\/]+"));
        }

        @Override
        public Map<String, String> getProperties(ShellProcessControl pc) throws Exception {
            try (CommandProcessControl c = pc.subShell(ShellTypes.CMD).command("systeminfo").start();){
                String text = c.readOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellProcessControl pc) throws Exception {
            Map<String, String> properties = this.getProperties(pc);
            return properties.get("OS Name") + " " + properties.get("OS Version").split(" ")[0];
        }

        @Override
        public Path getBaseInstallPath() {
            return Path.of(System.getenv("LOCALAPPDATA"), "X-Pipe");
        }

        @Override
        public UUID getSystemUUID(ShellProcessControl pc) throws Exception {
            try (CommandProcessControl c = pc.command("reg query \"Computer\\\\HKEY_LOCAL_MACHINE\\\\SOFTWARE\\\\Microsoft\\\\Cryptography\" /v MachineGuid");){
                String output = c.readOnlyStdout();
                UUID uUID = null;
                return uUID;
            }
        }
    }

    public static class Linux
    implements OsType {
        @Override
        public String getTempDirectory(ShellProcessControl pc) throws Exception {
            return "/tmp/";
        }

        @Override
        public String normalizeFileName(String file) {
            return String.join((CharSequence)"/", file.split("[\\\\/]+"));
        }

        @Override
        public String getName() {
            return "Linux";
        }

        @Override
        public Map<String, String> getProperties(ShellProcessControl pc) throws Exception {
            return null;
        }

        @Override
        public String determineOperatingSystemName(ShellProcessControl pc) throws Exception {
            String text;
            try (CommandProcessControl c = pc.command("lsb_release -a").start();){
                text = c.readOnlyStdout();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, ":").getOrDefault("Description", null);
                    return string;
                }
            }
            c = pc.command("cat /etc/*release").start();
            try {
                text = c.readOnlyStdout();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, "=").getOrDefault("PRETTY_NAME", null);
                    return string;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            String type = "Unknown";
            try (CommandProcessControl c = pc.command("uname -o").start();){
                String text2 = c.readOnlyStdout();
                if (c.getExitCode() == 0) {
                    type = text2.strip();
                }
            }
            String version = "?";
            try (CommandProcessControl c = pc.command("uname -r").start();){
                String text3 = c.readOnlyStdout();
                if (c.getExitCode() == 0) {
                    version = text3.strip();
                }
            }
            return type + " " + version;
        }

        @Override
        public Path getBaseInstallPath() {
            return Path.of("/opt/xpipe", new String[0]);
        }

        @Override
        public UUID getSystemUUID(ShellProcessControl pc) throws Exception {
            return null;
        }
    }
}

