/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.ProcessControl;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public interface CommandProcessControl
extends ProcessControl {
    public CommandProcessControl complex();

    default public InputStream startExternalStdout() throws Exception {
        try {
            this.start();
            final AtomicReference<String> err = new AtomicReference<String>("");
            this.accumulateStderr(s -> err.set((String)s));
            return new FilterInputStream(this.getStdout()){

                @Override
                public void close() throws IOException {
                    CommandProcessControl.this.close();
                    if (!((String)err.get()).isEmpty()) {
                        throw new IOException((String)err.get());
                    }
                }
            };
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    default public OutputStream startExternalStdin() throws Exception {
        try {
            this.start();
            this.discardOut();
            this.discardErr();
            return new FilterOutputStream(this.getStdin()){

                @Override
                public void close() throws IOException {
                    CommandProcessControl.this.closeStdin();
                    CommandProcessControl.this.close();
                }
            };
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public boolean waitFor();

    public CommandProcessControl customCharset(Charset var1);

    public int getExitCode();

    public CommandProcessControl elevated();

    @Override
    public CommandProcessControl start() throws Exception;

    public CommandProcessControl exitTimeout(Integer var1);

    public String readOnlyStdout() throws Exception;

    default public void discardOrThrow() throws Exception {
        this.readOrThrow();
    }

    public void accumulateStdout(Consumer<String> var1);

    public void accumulateStderr(Consumer<String> var1);

    public String readOrThrow() throws Exception;

    default public boolean startAndCheckExit() {
        boolean bl;
        block8: {
            CommandProcessControl pc = this.start();
            try {
                bl = pc.discardAndCheckExit();
                if (pc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pc != null) {
                        try {
                            pc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            pc.close();
        }
        return bl;
    }

    default public boolean discardAndCheckExit() {
        try {
            this.discardOrThrow();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void discardOut();

    public void discardErr();
}

