/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.charsetter.Charsettable;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.impl.TextReadConnection;
import io.xpipe.core.impl.TextWriteConnection;
import io.xpipe.core.source.TextDataSource;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.StreamDataStore;

@JsonTypeName(value="text")
@JsonDeserialize(builder=TextSourceBuilderImpl.class)
public final class TextSource
extends TextDataSource<StreamDataStore>
implements Charsettable {
    private final StreamCharset charset;
    private final NewLine newLine;

    @Override
    protected io.xpipe.core.source.TextWriteConnection newWriteConnection(WriteMode mode) {
        return new TextWriteConnection(this);
    }

    @Override
    protected io.xpipe.core.source.TextReadConnection newReadConnection() {
        return new TextReadConnection(this);
    }

    protected TextSource(TextSourceBuilder<?, ?> b) {
        super(b);
        this.charset = b.charset;
        this.newLine = b.newLine;
    }

    public static TextSourceBuilder<?, ?> builder() {
        return new TextSourceBuilderImpl();
    }

    @Override
    public StreamCharset getCharset() {
        return this.charset;
    }

    public NewLine getNewLine() {
        return this.newLine;
    }

    public static abstract class TextSourceBuilder<C extends TextSource, B extends TextSourceBuilder<C, B>>
    extends TextDataSource.TextDataSourceBuilder<StreamDataStore, C, B> {
        private StreamCharset charset;
        private NewLine newLine;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B charset(StreamCharset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        public B newLine(NewLine newLine) {
            this.newLine = newLine;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TextSource.TextSourceBuilder(super=" + super.toString() + ", charset=" + String.valueOf(this.charset) + ", newLine=" + String.valueOf((Object)this.newLine) + ")";
        }
    }

    @JsonTypeName(value="text")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class TextSourceBuilderImpl
    extends TextSourceBuilder<TextSource, TextSourceBuilderImpl> {
        private TextSourceBuilderImpl() {
        }

        @Override
        protected TextSourceBuilderImpl self() {
            return this;
        }

        @Override
        public TextSource build() {
            return new TextSource(this);
        }
    }
}

