/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.charsetter.Charsetter;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.source.DataSourceReadConnection;
import io.xpipe.core.store.StreamDataStore;
import java.io.InputStream;
import java.io.Reader;

public abstract class StreamReadConnection
implements DataSourceReadConnection {
    protected final StreamDataStore store;
    private final StreamCharset charset;
    protected InputStream inputStream;
    protected Reader reader;

    public StreamReadConnection(StreamDataStore store, StreamCharset charset) {
        this.store = store;
        this.charset = charset;
    }

    @Override
    public boolean canRead() throws Exception {
        return this.store.canOpen();
    }

    @Override
    public void init() throws Exception {
        if (this.inputStream != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.inputStream = this.store.openBufferedInput();
        if (this.charset != null) {
            this.reader = Charsetter.get().reader(this.inputStream, this.charset);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.inputStream == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputStream.close();
    }
}

