/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.store.DataFlow;
import io.xpipe.core.store.KnownFormatStreamDataStore;
import io.xpipe.core.util.JacksonizedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;

@JsonTypeName(value="drain")
@JsonDeserialize(builder=SinkDrainStoreBuilderImpl.class)
public class SinkDrainStore
extends JacksonizedValue
implements KnownFormatStreamDataStore {
    private final String description;
    private final StreamCharset charset;
    private final NewLine newLine;
    @JsonIgnore
    private State state;
    @JsonIgnore
    private Pipe pipe;

    @Override
    public DataFlow getFlow() {
        if (this.state == State.NONE_CONNECTED) {
            return DataFlow.INPUT_OR_OUTPUT;
        }
        if (this.state == State.PRODUCER_CONNECTED) {
            return DataFlow.INPUT;
        }
        if (this.state == State.CONSUMER_CONNECTED) {
            return DataFlow.OUTPUT;
        }
        return null;
    }

    private void waitForOpen() {
        while (this.state != State.OPEN) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public boolean canOpen() throws Exception {
        return this.state == State.PRODUCER_CONNECTED;
    }

    @Override
    public InputStream openInput() throws Exception {
        this.checkState(false);
        if (this.state == State.PRODUCER_CONNECTED) {
            this.state = State.OPEN;
        }
        if (this.state == State.NONE_CONNECTED) {
            this.state = State.CONSUMER_CONNECTED;
            this.waitForOpen();
        }
        try {
            this.openPipe();
            return Channels.newInputStream(this.pipe.source());
        }
        catch (Exception ex) {
            this.state = State.CLOSED;
            throw ex;
        }
    }

    @Override
    public OutputStream openOutput() throws Exception {
        this.checkState(true);
        if (this.state == State.CONSUMER_CONNECTED) {
            this.state = State.OPEN;
        }
        if (this.state == State.NONE_CONNECTED) {
            this.state = State.PRODUCER_CONNECTED;
            this.waitForOpen();
        }
        try {
            this.openPipe();
            return Channels.newOutputStream(this.pipe.sink());
        }
        catch (Exception ex) {
            this.state = State.CLOSED;
            throw ex;
        }
    }

    private void openPipe() throws IOException {
        if (this.pipe == null) {
            this.pipe = Pipe.open();
        }
    }

    private void checkState(boolean isProducer) {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("Drain has already been closed");
        }
        if (this.state == State.OPEN) {
            throw new IllegalStateException("Drain is already open");
        }
        if (this.state == State.PRODUCER_CONNECTED && isProducer) {
            throw new IllegalStateException("Producer is already connected");
        }
        if (this.state == State.CONSUMER_CONNECTED && !isProducer) {
            throw new IllegalStateException("Consumer is already connected");
        }
    }

    private static State $default$state() {
        return State.NONE_CONNECTED;
    }

    protected SinkDrainStore(SinkDrainStoreBuilder<?, ?> b) {
        super(b);
        this.description = b.description;
        this.charset = b.charset;
        this.newLine = b.newLine;
        this.state = b.state$set ? b.state$value : SinkDrainStore.$default$state();
        this.pipe = b.pipe;
    }

    public static SinkDrainStoreBuilder<?, ?> builder() {
        return new SinkDrainStoreBuilderImpl();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public StreamCharset getCharset() {
        return this.charset;
    }

    @Override
    public NewLine getNewLine() {
        return this.newLine;
    }

    public State getState() {
        return this.state;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    @JsonIgnore
    public void setState(State state) {
        this.state = state;
    }

    public static enum State {
        NONE_CONNECTED,
        PRODUCER_CONNECTED,
        CONSUMER_CONNECTED,
        OPEN,
        CLOSED;

    }

    public static abstract class SinkDrainStoreBuilder<C extends SinkDrainStore, B extends SinkDrainStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private String description;
        private StreamCharset charset;
        private NewLine newLine;
        private boolean state$set;
        private State state$value;
        private Pipe pipe;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        public B charset(StreamCharset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        public B newLine(NewLine newLine) {
            this.newLine = newLine;
            return (B)this.self();
        }

        @JsonIgnore
        public B state(State state) {
            this.state$value = state;
            this.state$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B pipe(Pipe pipe) {
            this.pipe = pipe;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SinkDrainStore.SinkDrainStoreBuilder(super=" + super.toString() + ", description=" + this.description + ", charset=" + String.valueOf(this.charset) + ", newLine=" + String.valueOf((Object)this.newLine) + ", state$value=" + String.valueOf((Object)this.state$value) + ", pipe=" + String.valueOf(this.pipe) + ")";
        }
    }

    @JsonTypeName(value="drain")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SinkDrainStoreBuilderImpl
    extends SinkDrainStoreBuilder<SinkDrainStore, SinkDrainStoreBuilderImpl> {
        private SinkDrainStoreBuilderImpl() {
        }

        @Override
        protected SinkDrainStoreBuilderImpl self() {
            return this;
        }

        @Override
        public SinkDrainStore build() {
            return new SinkDrainStore(this);
        }
    }
}

