/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.impl.LocalProcessControlProvider;
import io.xpipe.core.process.ShellProcessControl;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.MachineStore;
import io.xpipe.core.util.JacksonizedValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@JsonTypeName(value="local")
public class LocalStore
extends JacksonizedValue
implements FileSystemStore,
MachineStore {
    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean exists(String file) {
        return Files.exists(Path.of(file, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean mkdirs(String file) throws Exception {
        try {
            Files.createDirectories(Path.of(file, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public InputStream openInput(String file) throws Exception {
        Path p = Path.of(file, new String[0]);
        return Files.newInputStream(p, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutput(String file) throws Exception {
        Path p = Path.of(file, new String[0]);
        return Files.newOutputStream(p, new OpenOption[0]);
    }

    @Override
    public ShellProcessControl create() {
        return LocalProcessControlProvider.create();
    }
}

