/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.FilenameStore;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.JacksonizedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonTypeName(value="file")
@JsonDeserialize(builder=FileStoreBuilderImpl.class)
public class FileStore
extends JacksonizedValue
implements FilenameStore,
StreamDataStore {
    FileSystemStore fileSystem;
    String file;

    public FileStore(FileSystemStore fileSystem, String file) {
        this.fileSystem = fileSystem;
        this.file = file;
    }

    public String getParent() {
        Matcher matcher = Pattern.compile("^(.+?)[^\\\\/]+$").matcher(this.file);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to determine parent of " + this.file);
        }
        return matcher.group(1);
    }

    public final boolean isLocal() {
        return this.fileSystem instanceof LocalStore;
    }

    public static FileStore local(Path p) {
        return new FileStore(new LocalStore(), p.toString());
    }

    public static FileStore local(String p) {
        return new FileStore(new LocalStore(), p);
    }

    @Override
    public void checkComplete() throws Exception {
        if (this.fileSystem == null) {
            throw new IllegalStateException("File system is missing");
        }
        if (this.file == null) {
            throw new IllegalStateException("File is missing");
        }
    }

    @Override
    public InputStream openInput() throws Exception {
        return this.fileSystem.openInput(this.file);
    }

    @Override
    public OutputStream openOutput() throws Exception {
        if (!this.fileSystem.mkdirs(this.getParent())) {
            throw new IOException("Unable to create directory: " + this.getParent());
        }
        return this.fileSystem.openOutput(this.file);
    }

    @Override
    public boolean canOpen() throws Exception {
        return this.fileSystem.exists(this.file);
    }

    @Override
    public String getFileName() {
        String[] split = this.file.split("[\\\\/]");
        if (split.length == 0) {
            return "";
        }
        return split[split.length - 1];
    }

    protected FileStore(FileStoreBuilder<?, ?> b) {
        super(b);
        this.fileSystem = b.fileSystem;
        this.file = b.file;
    }

    public static FileStoreBuilder<?, ?> builder() {
        return new FileStoreBuilderImpl();
    }

    public FileSystemStore getFileSystem() {
        return this.fileSystem;
    }

    public String getFile() {
        return this.file;
    }

    public static abstract class FileStoreBuilder<C extends FileStore, B extends FileStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private FileSystemStore fileSystem;
        private String file;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fileSystem(FileSystemStore fileSystem) {
            this.fileSystem = fileSystem;
            return (B)this.self();
        }

        public B file(String file) {
            this.file = file;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FileStore.FileStoreBuilder(super=" + super.toString() + ", fileSystem=" + String.valueOf(this.fileSystem) + ", file=" + this.file + ")";
        }
    }

    @JsonTypeName(value="file")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class FileStoreBuilderImpl
    extends FileStoreBuilder<FileStore, FileStoreBuilderImpl> {
        private FileStoreBuilderImpl() {
        }

        @Override
        protected FileStoreBuilderImpl self() {
            return this;
        }

        @Override
        public FileStore build() {
            return new FileStore(this);
        }
    }
}

