/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import java.util.Arrays;
import java.util.List;

public class FileNames {
    public static String getFileName(String file) {
        String[] split = file.split("[\\\\/]");
        if (split.length == 0) {
            return "";
        }
        return split[split.length - 1];
    }

    public static String join(String ... parts) {
        String joined = String.join((CharSequence)"/", parts);
        return FileNames.normalize(joined);
    }

    public static String getParent(String file) {
        return file.substring(0, file.length() - FileNames.getFileName(file).length() - 1);
    }

    public static boolean startsWith(String file, String start) {
        return FileNames.normalize(file).startsWith(FileNames.normalize(start));
    }

    public static String normalize(String file) {
        boolean backslash = file.contains("\\");
        return backslash ? FileNames.toWindows(file) : FileNames.toUnix(file);
    }

    private static List<String> split(String file) {
        String[] split = file.split("[\\\\/]");
        return Arrays.stream(split).filter(s -> !s.isEmpty()).toList();
    }

    public static String toUnix(String file) {
        String joined = String.join((CharSequence)"/", FileNames.split(file));
        return file.startsWith("/") ? "/" + joined : joined;
    }

    public static String toWindows(String file) {
        return String.join((CharSequence)"\\", FileNames.split(file));
    }
}

