/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.source.TableMapping;
import io.xpipe.core.source.TableWriteConnection;
import java.util.ArrayList;
import java.util.List;

public abstract class BatchTableWriteConnection
implements TableWriteConnection {
    public static final int DEFAULT_BATCH_SIZE = 2000;
    protected final int batchSize = 2000;
    private final List<DataStructureNode> batch = new ArrayList<DataStructureNode>();
    private TableMapping mapping;

    @Override
    public final DataStructureNodeAcceptor<TupleNode> writeLinesAcceptor(TableMapping mapping) {
        this.mapping = mapping;
        return node -> {
            if (this.batch.size() < 2000) {
                this.batch.add(node);
                if (this.batch.size() < 2000) {
                    return true;
                }
            }
            ArrayNode array = ArrayNode.of(this.batch);
            boolean returned = this.writeBatchLinesAcceptor(mapping).accept(array);
            this.batch.clear();
            return returned;
        };
    }

    @Override
    public final void close() throws Exception {
        try {
            if (this.batch.size() > 0) {
                ArrayNode array = ArrayNode.of(this.batch);
                boolean returned = this.writeBatchLinesAcceptor(this.mapping).accept(array);
                this.batch.clear();
            }
        }
        finally {
            this.onClose(this.mapping);
        }
    }

    protected abstract void onClose(TableMapping var1) throws Exception;

    protected abstract DataStructureNodeAcceptor<ArrayNode> writeBatchLinesAcceptor(TableMapping var1);
}

