/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.typed;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.SimpleTupleNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.node.ValueNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.DataTypeVisitors;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.typed.TypedAbstractReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TypedDataStructureNodeReader
implements TypedAbstractReader {
    private final Stack<List<DataStructureNode>> children;
    private final Stack<DataStructureNode> nodes;
    private final List<DataType> flattened = new ArrayList<DataType>();
    private DataStructureNode readNode;
    private int arrayDepth;
    private DataType expectedType;
    private int currentExpectedTypeIndex;

    private TypedDataStructureNodeReader(DataType type) {
        type.visit(DataTypeVisitors.flatten(this.flattened::add));
        this.children = new Stack();
        this.nodes = new Stack();
        this.expectedType = this.flattened.get(0);
    }

    public static TypedDataStructureNodeReader of(DataType type) {
        return new TypedDataStructureNodeReader(type);
    }

    @Override
    public void onNodeBegin() {
        if (this.nodes.size() != 0 || this.children.size() != 0) {
            throw new IllegalStateException("Reader did not completely reset");
        }
        this.readNode = null;
    }

    @Override
    public boolean isDone() {
        return this.readNode != null;
    }

    @Override
    public DataStructureNode create() {
        if (this.readNode == null) {
            throw new IllegalStateException("Reader is not finished yet");
        }
        return this.readNode;
    }

    @Override
    public void onNodeEnd() {
        if (this.nodes.size() != 0 || this.children.size() != 0 || this.readNode == null) {
            throw new IllegalStateException("Reader is not finished yet");
        }
        this.expectedType = this.flattened.get(0);
        this.currentExpectedTypeIndex = 0;
    }

    private void finishNode(DataStructureNode node) {
        if (this.nodes.empty()) {
            this.readNode = node;
        } else {
            this.children.peek().add(node);
        }
    }

    @Override
    public void onValue(byte[] data, Map<Integer, String> metaAttributes) {
        if (!this.expectedType.isValue()) {
            throw new IllegalStateException("Expected " + this.expectedType.getName() + " but got value");
        }
        DataStructureNode val = ValueNode.of(data).tag(metaAttributes);
        this.finishNode(val);
        this.moveExpectedType(false);
    }

    private boolean isInArray() {
        return this.arrayDepth >= 1;
    }

    @Override
    public void onGenericNode(DataStructureNode node) {
        if (!this.expectedType.isWildcard()) {
            throw new IllegalStateException("Expected " + this.expectedType.getName() + " but got generic node");
        }
        this.finishNode(node);
        this.moveExpectedType(false);
    }

    @Override
    public void onTupleBegin(TupleType type) {
        if (!this.expectedType.isTuple()) {
            throw new IllegalStateException("Expected " + this.expectedType.getName() + " but got tuple");
        }
        TupleType tupleType = this.expectedType.asTuple();
        this.moveExpectedType(false);
        ArrayList<DataStructureNode> l = new ArrayList<DataStructureNode>(tupleType.getSize());
        this.children.push(l);
        SimpleTupleNode newNode = new SimpleTupleNode(tupleType.getNames(), l);
        this.nodes.push(newNode);
    }

    @Override
    public void onTupleEnd(Map<Integer, String> metaAttributes) {
        this.children.pop();
        DataStructureNode popped = this.nodes.pop();
        if (!popped.isTuple()) {
            throw new IllegalStateException("No tuple to end");
        }
        TupleNode tuple = popped.tag(metaAttributes).asTuple();
        if (tuple.getKeyNames().size() != tuple.getNodes().size()) {
            throw new IllegalStateException("Tuple node size mismatch");
        }
        this.finishNode(popped);
    }

    private void moveExpectedType(boolean force) {
        if (!this.isInArray() || force) {
            ++this.currentExpectedTypeIndex;
            this.expectedType = this.currentExpectedTypeIndex == this.flattened.size() ? null : this.flattened.get(this.currentExpectedTypeIndex);
        }
    }

    @Override
    public void onArrayBegin(int size) {
        if (!this.expectedType.isArray()) {
            throw new IllegalStateException("Expected " + this.expectedType.getName() + " but got array");
        }
        ++this.arrayDepth;
        this.moveExpectedType(true);
        ArrayList<DataStructureNode> l = new ArrayList<DataStructureNode>();
        this.children.push(l);
        ArrayNode newNode = ArrayNode.of(l);
        this.nodes.push(newNode);
    }

    @Override
    public void onArrayEnd(Map<Integer, String> metaAttributes) {
        if (!this.isInArray()) {
            throw new IllegalStateException("No array to end");
        }
        --this.arrayDepth;
        this.moveExpectedType(true);
        this.children.pop();
        DataStructureNode popped = this.nodes.pop().tag(metaAttributes);
        this.finishNode(popped);
    }
}

