/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.typed;

import io.xpipe.core.data.generic.GenericDataStreamParser;
import io.xpipe.core.data.generic.GenericDataStructureNodeReader;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeIO;
import io.xpipe.core.data.type.ArrayType;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.typed.TypedAbstractReader;
import io.xpipe.core.data.typed.TypedDataStreamCallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;

public class TypedDataStreamParser {
    private final DataType dataType;
    private GenericDataStructureNodeReader genericReader;

    public TypedDataStreamParser(DataType dataType) {
        this.dataType = dataType;
    }

    private boolean hasNext(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            return false;
        }
        if (b != 5) {
            throw new IllegalStateException("Unexpected value: " + b);
        }
        return true;
    }

    public void parseStructures(InputStream in, TypedAbstractReader cb, Consumer<DataStructureNode> consumer) throws IOException {
        while (this.hasNext(in)) {
            cb.onNodeBegin();
            this.parse(in, cb, this.dataType);
            cb.onNodeEnd();
            consumer.accept(cb.create());
        }
    }

    public DataStructureNode parseStructure(InputStream in, TypedAbstractReader cb) throws IOException {
        if (!this.hasNext(in)) {
            return null;
        }
        cb.onNodeBegin();
        this.parse(in, cb, this.dataType);
        cb.onNodeEnd();
        return cb.create();
    }

    public void parse(InputStream in, TypedDataStreamCallback cb) throws IOException {
        this.parse(in, cb, this.dataType);
    }

    private void parse(InputStream in, TypedDataStreamCallback cb, DataType type) throws IOException {
        int b = in.read();
        if (b == 5) {
            b = in.read();
        }
        switch (b) {
            case 6: {
                if (!type.isTuple()) {
                    throw new IllegalStateException("Got tuple but expected " + type.getName());
                }
                TupleType tt = (TupleType)type;
                this.parseTypedTuple(in, cb, tt);
                break;
            }
            case 7: {
                if (!type.isArray()) {
                    throw new IllegalStateException("Got array but expected " + type.getName());
                }
                ArrayType at = (ArrayType)type;
                this.parseTypedArray(in, cb, at);
                break;
            }
            case 8: {
                if (!type.isValue()) {
                    throw new IllegalStateException("Got value but expected " + type.getName());
                }
                this.parseValue(in, cb);
                break;
            }
            case 0: {
                if (!type.isWildcard()) {
                    throw new IllegalStateException("Got structure but expected " + type.getName());
                }
                GenericDataStreamParser.parse(in, this.getGenericReader());
                cb.onGenericNode(this.getGenericReader().create());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type id: " + b);
            }
        }
    }

    private void parseTypedTuple(InputStream in, TypedDataStreamCallback cb, TupleType type) throws IOException {
        cb.onTupleBegin(type);
        for (int i = 0; i < type.getSize(); ++i) {
            this.parse(in, cb, type.getTypes().get(i));
        }
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onTupleEnd(attributes);
    }

    private GenericDataStructureNodeReader getGenericReader() {
        if (this.genericReader == null) {
            this.genericReader = new GenericDataStructureNodeReader();
        }
        return this.genericReader;
    }

    private void parseTypedArray(InputStream in, TypedDataStreamCallback cb, ArrayType type) throws IOException {
        int size = DataStructureNodeIO.parseShort(in);
        cb.onArrayBegin(size);
        for (int i = 0; i < size; ++i) {
            this.parse(in, cb, type.getSharedType());
        }
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onArrayEnd(attributes);
    }

    private void parseValue(InputStream in, TypedDataStreamCallback cb) throws IOException {
        short size = DataStructureNodeIO.parseShort(in);
        byte[] data = in.readNBytes(size);
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onValue(data, attributes);
    }
}

