/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DataStructureNodePointer {
    private final List<Element> path;

    public DataStructureNodePointer(List<Element> path) {
        this.path = path;
        if (path.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromBase(DataStructureNodePointer pointer) {
        return new Builder(pointer);
    }

    public String toString() {
        return "/" + this.path.stream().map((Function<Element, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/xpipe/core/data/node/DataStructureNodePointer$Element;)Ljava/lang/String;)()).collect(Collectors.joining("/"));
    }

    public int size() {
        return this.path.size();
    }

    public boolean isValid(DataStructureNode input) {
        return this.get(input) != null;
    }

    public DataStructureNode get(DataStructureNode root) {
        DataStructureNode current = root;
        for (Element value : this.path) {
            DataStructureNode found = value.tryMatch(current);
            if (found == null) {
                return null;
            }
            current = found;
        }
        return current;
    }

    public Optional<DataStructureNode> getIfPresent(DataStructureNode root) {
        return Optional.ofNullable(this.get(root));
    }

    public List<Element> getPath() {
        return this.path;
    }

    public static class Builder {
        private final List<Element> path;

        public Builder() {
            this.path = new ArrayList<Element>();
        }

        private Builder(List<Element> path) {
            this.path = path;
        }

        public Builder(DataStructureNodePointer pointer) {
            this.path = new ArrayList<Element>(pointer.path);
        }

        public Builder copy() {
            return new Builder(new ArrayList<Element>(this.path));
        }

        public Builder name(String name) {
            this.path.add(new NameElement(name));
            return this;
        }

        public Builder index(int index) {
            this.path.add(new IndexElement(index));
            return this;
        }

        public Builder supplier(Supplier<String> keySupplier) {
            this.path.add(new SupplierElement(keySupplier));
            return this;
        }

        public Builder function(Function<DataStructureNode, String> keyFunc) {
            this.path.add(new FunctionElement(keyFunc));
            return this;
        }

        public Builder selector(Predicate<DataStructureNode> selector) {
            this.path.add(new SelectorElement(selector));
            return this;
        }

        public Builder pointerEvaluation(DataStructureNodePointer pointer) {
            return this.pointerEvaluation(pointer, n -> {
                if (!n.isValue()) {
                    return null;
                }
                return n.asString();
            });
        }

        public Builder pointerEvaluation(DataStructureNodePointer pointer, Function<DataStructureNode, String> converter) {
            this.path.add(new FunctionElement(current -> {
                DataStructureNode res = pointer.get((DataStructureNode)current);
                if (res != null) {
                    return (String)converter.apply(res);
                }
                return null;
            }));
            return this;
        }

        public DataStructureNodePointer build() {
            return new DataStructureNodePointer(this.path);
        }
    }

    public static interface Element {
        public DataStructureNode tryMatch(DataStructureNode var1);

        default public String getKey(DataStructureNode n) {
            return null;
        }
    }

    public record SelectorElement(Predicate<DataStructureNode> selector) implements Element
    {
        @Override
        public DataStructureNode tryMatch(DataStructureNode n) {
            Optional<DataStructureNode> res = n.stream().filter(this.selector).findAny();
            return res.orElse(null);
        }

        @Override
        public String toString() {
            return "[$(...)]";
        }
    }

    public record FunctionElement(Function<DataStructureNode, String> keyFunc) implements Element
    {
        @Override
        public DataStructureNode tryMatch(DataStructureNode n) {
            String name = this.keyFunc.apply(n);
            if (name != null) {
                return n.forKeyIfPresent(name).orElse(null);
            }
            return null;
        }

        @Override
        public String getKey(DataStructureNode n) {
            return this.keyFunc.apply(n);
        }

        @Override
        public String toString() {
            return "[$s]";
        }
    }

    public record SupplierElement(Supplier<String> keySupplier) implements Element
    {
        @Override
        public DataStructureNode tryMatch(DataStructureNode n) {
            String name = this.keySupplier.get();
            if (name != null) {
                return n.forKeyIfPresent(name).orElse(null);
            }
            return null;
        }

        @Override
        public String getKey(DataStructureNode n) {
            return this.keySupplier.get();
        }

        @Override
        public String toString() {
            return "[$s]";
        }
    }

    public record IndexElement(int index) implements Element
    {
        @Override
        public DataStructureNode tryMatch(DataStructureNode n) {
            if (n.size() > this.index) {
                return n.at(this.index);
            }
            return null;
        }

        @Override
        public String toString() {
            return "[" + this.index + "]";
        }
    }

    public record NameElement(String name) implements Element
    {
        @Override
        public DataStructureNode tryMatch(DataStructureNode n) {
            return n.forKeyIfPresent(this.name).orElse(null);
        }

        @Override
        public String getKey(DataStructureNode n) {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

