/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.generic;

import io.xpipe.core.data.generic.GenericDataStreamCallback;
import io.xpipe.core.data.generic.GenericDataStructureNodeReader;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericDataStreamParser {
    public static DataStructureNode parse(InputStream in) throws IOException {
        GenericDataStructureNodeReader reader = new GenericDataStructureNodeReader();
        GenericDataStreamParser.parse(in, reader);
        return reader.create();
    }

    public static List<DataStructureNode> parseN(InputStream in, int n) throws IOException {
        ArrayList<DataStructureNode> list = new ArrayList<DataStructureNode>();
        GenericDataStructureNodeReader reader = new GenericDataStructureNodeReader();
        for (int i = 0; i < n; ++i) {
            GenericDataStreamParser.parse(in, reader);
            list.add(reader.create());
        }
        return list;
    }

    public static void parse(InputStream in, GenericDataStreamCallback cb) throws IOException {
        int b = in.read();
        if (b == -1) {
            return;
        }
        if (b == 0) {
            b = in.read();
        }
        switch (b) {
            case 1: {
                GenericDataStreamParser.parseTuple(in, cb);
                break;
            }
            case 2: {
                GenericDataStreamParser.parseArray(in, cb);
                break;
            }
            case 3: {
                GenericDataStreamParser.parseValue(in, cb);
                break;
            }
            case 4: {
                GenericDataStreamParser.parseName(in, cb);
                GenericDataStreamParser.parse(in, cb);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type id: " + b);
            }
        }
    }

    private static void parseName(InputStream in, GenericDataStreamCallback cb) throws IOException {
        short nameLength = DataStructureNodeIO.parseShort(in);
        String name = new String(in.readNBytes(nameLength));
        cb.onName(name);
    }

    private static void parseTuple(InputStream in, GenericDataStreamCallback cb) throws IOException {
        int size = DataStructureNodeIO.parseShort(in);
        cb.onTupleStart(size);
        for (int i = 0; i < size; ++i) {
            GenericDataStreamParser.parse(in, cb);
        }
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onTupleEnd(attributes);
    }

    private static void parseArray(InputStream in, GenericDataStreamCallback cb) throws IOException {
        int size = DataStructureNodeIO.parseShort(in);
        cb.onArrayStart(size);
        for (int i = 0; i < size; ++i) {
            GenericDataStreamParser.parse(in, cb);
        }
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onArrayEnd(attributes);
    }

    private static void parseValue(InputStream in, GenericDataStreamCallback cb) throws IOException {
        short size = DataStructureNodeIO.parseShort(in);
        byte[] data = in.readNBytes(size);
        Map<Integer, String> attributes = DataStructureNodeIO.parseAttributes(in);
        cb.onValue(data, attributes);
    }
}

