/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.charsetter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public final class StreamCharset {
    public static final StreamCharset UTF8 = new StreamCharset(StandardCharsets.UTF_8, null);
    public static final StreamCharset UTF8_BOM = new StreamCharset(StandardCharsets.UTF_8, new byte[]{-17, -69, -65});
    public static final StreamCharset UTF16_BE = new StreamCharset(StandardCharsets.UTF_16BE, null);
    public static final StreamCharset UTF16_BE_BOM = new StreamCharset(StandardCharsets.UTF_16BE, new byte[]{-2, -1});
    public static final StreamCharset UTF16_LE = new StreamCharset(StandardCharsets.UTF_16LE, null);
    public static final StreamCharset UTF16_LE_BOM = new StreamCharset(StandardCharsets.UTF_16LE, new byte[]{-1, -2});
    public static final StreamCharset UTF32_LE = new StreamCharset(Charset.forName("utf-32le"), null);
    public static final StreamCharset UTF32_LE_BOM = new StreamCharset(Charset.forName("utf-32le"), new byte[]{0, 0, -2, -1});
    public static final StreamCharset UTF32_BE = new StreamCharset(Charset.forName("utf-32be"), null);
    public static final StreamCharset UTF32_BE_BOM = new StreamCharset(Charset.forName("utf-32be"), new byte[]{-1, -2, 0, 0});
    public static final List<StreamCharset> COMMON = List.of(UTF8, UTF8_BOM, UTF16_BE, UTF16_BE_BOM, UTF16_LE, UTF16_LE_BOM, new StreamCharset(StandardCharsets.US_ASCII, null), new StreamCharset(StandardCharsets.ISO_8859_1, null), new StreamCharset(Charset.forName("Windows-1251"), null), new StreamCharset(Charset.forName("Windows-1252"), null));
    private static final List<StreamCharset> RARE_KNOWN = List.of(UTF32_LE, UTF32_LE_BOM, UTF32_BE, UTF32_BE_BOM);
    public static final List<StreamCharset> RARE = Stream.concat(RARE_KNOWN.stream(), Charset.availableCharsets().values().stream().filter(charset -> !charset.equals(StandardCharsets.UTF_16) && !charset.equals(Charset.forName("utf-32")) && !charset.displayName().startsWith("x-") && !charset.displayName().startsWith("X-") && !charset.displayName().endsWith("-BOM") && COMMON.stream().noneMatch(c -> c.getCharset().equals(charset)) && RARE_KNOWN.stream().noneMatch(c -> c.getCharset().equals(charset))).map(charset -> new StreamCharset((Charset)charset, null))).toList();
    private final Charset charset;
    private final byte[] byteOrderMark;

    public static StreamCharset get(Charset charset, boolean byteOrderMark) {
        return Stream.concat(COMMON.stream(), RARE.stream()).filter(streamCharset -> streamCharset.getCharset().equals(charset) && streamCharset.hasByteOrderMark() == byteOrderMark).findFirst().orElseThrow();
    }

    @JsonCreator
    public static StreamCharset get(String s) {
        boolean byteOrderMark = s.endsWith("-bom");
        Charset charset = Charset.forName(s.substring(0, s.length() - (byteOrderMark ? 4 : 0)));
        return StreamCharset.get(charset, byteOrderMark);
    }

    @JsonValue
    public String toString() {
        return this.getCharset().name().toLowerCase(Locale.ROOT) + (this.hasByteOrderMark() ? "-bom" : "");
    }

    public boolean hasByteOrderMark() {
        return this.byteOrderMark != null;
    }

    public StreamCharset(Charset charset, byte[] byteOrderMark) {
        this.charset = charset;
        this.byteOrderMark = byteOrderMark;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public byte[] getByteOrderMark() {
        return this.byteOrderMark;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamCharset)) {
            return false;
        }
        StreamCharset other = (StreamCharset)o;
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        return Arrays.equals(this.getByteOrderMark(), other.getByteOrderMark());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + Arrays.hashCode(this.getByteOrderMark());
        return result;
    }
}

