/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.connector;

import io.xpipe.beacon.BeaconClient;
import io.xpipe.beacon.BeaconConnection;
import io.xpipe.beacon.BeaconException;
import io.xpipe.beacon.BeaconServer;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.cli.DialogExchange;
import io.xpipe.core.dialog.DialogElement;
import io.xpipe.core.dialog.DialogReference;
import io.xpipe.core.util.XPipeDaemonMode;
import io.xpipe.core.util.XPipeInstallation;
import java.util.Optional;

public final class XPipeApiConnection
extends BeaconConnection {
    private XPipeApiConnection() {
    }

    public static XPipeApiConnection open() {
        XPipeApiConnection con = new XPipeApiConnection();
        con.constructSocket();
        return con;
    }

    public static void finishDialog(DialogReference reference) {
        try (XPipeApiConnection con = new XPipeApiConnection();){
            DialogExchange.Response response;
            con.constructSocket();
            DialogElement element = reference.getStart();
            do {
                if (element != null && element.requiresExplicitUserInput()) {
                    throw new IllegalStateException();
                }
                response = (DialogExchange.Response)con.performSimpleExchange((RequestMessage)DialogExchange.Request.builder().dialogKey(reference.getDialogId()).build());
                element = response.getElement();
            } while (response.getElement() != null);
        }
        catch (BeaconException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeaconException((Throwable)e);
        }
    }

    public static void execute(Handler handler) {
        try (XPipeApiConnection con = new XPipeApiConnection();){
            con.constructSocket();
            handler.handle(con);
        }
        catch (BeaconException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeaconException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(Mapper<T> mapper) {
        try (XPipeApiConnection con = new XPipeApiConnection();){
            con.constructSocket();
            T t = mapper.handle(con);
            return t;
        }
        catch (BeaconException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeaconException((Throwable)e);
        }
    }

    public static Optional<BeaconClient> waitForStartup(Process process) {
        for (int i = 0; i < 160; ++i) {
            if (process != null && !process.isAlive() && process.exitValue() != 0) {
                return Optional.empty();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Optional s = BeaconClient.tryConnect((BeaconClient.ClientInformation)BeaconClient.ApiClientInformation.builder().version("?").language("Java").build());
            if (!s.isPresent()) continue;
            return s;
        }
        return Optional.empty();
    }

    public static void waitForShutdown() {
        for (int i = 0; i < 40; ++i) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean r = BeaconServer.isRunning();
            if (r) continue;
            return;
        }
    }

    protected void constructSocket() {
        if (!BeaconServer.isRunning()) {
            try {
                this.start();
            }
            catch (Exception ex) {
                throw new BeaconException("Unable to start xpipe daemon", (Throwable)ex);
            }
            Optional<BeaconClient> r = XPipeApiConnection.waitForStartup(null);
            if (r.isEmpty()) {
                throw new BeaconException("Wait for xpipe daemon timed out");
            }
            this.beaconClient = r.get();
            return;
        }
        try {
            this.beaconClient = BeaconClient.connect((BeaconClient.ClientInformation)BeaconClient.ApiClientInformation.builder().version("?").language("Java").build());
        }
        catch (Exception ex) {
            throw new BeaconException("Unable to connect to running xpipe daemon", (Throwable)ex);
        }
    }

    private void start() throws Exception {
        String installation = XPipeInstallation.getLocalDefaultInstallationBasePath();
        BeaconServer.start((String)installation, (XPipeDaemonMode)XPipeDaemonMode.TRAY);
    }

    @FunctionalInterface
    public static interface Handler {
        public void handle(BeaconConnection var1);
    }

    @FunctionalInterface
    public static interface Mapper<T> {
        public T handle(BeaconConnection var1);
    }
}

